package com.naivete.framework.admin.boot.service;

import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;

/**
 * 权限服务接口
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 23:13
 **/
public interface FunctionService {

    /**
     * 根据用户编码查询所有权限信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:13
     **/
    ResultList<FunctionDO> queryListByUserCode(String userCode);

    /**
     * 查询所有的功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:13
     **/
    ResultList<FunctionDO> queryAll();

    /**
     * 查询所有的子功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:13
     **/
    ResultList<FunctionDO> queryChildFun(String parentCode);

    /**
     * 新增
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:14
     **/
    Result<Void> addOne(FunctionDO function);

    /**
     * 修改
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:14
     **/
    Result<Void> modifyOne(FunctionDO function);

    /**
     * 根据角色编码查询所有权限信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:14
     **/
    ResultList<FunctionDO> queryListByRoleCode(String roleCode);

    /**
     * 根据编码删除功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:14
     **/
    Result<Void> removeFun(String code);

}
