package com.naivete.framework.admin.boot.service;

import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;

/**
 * 用户服务接口
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 23:14
 **/
public interface UserService {

    /**
     * 分页查询用户列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:15
     **/
    ResultList<UserDO> queryList(Query<UserDO> query);

    /**
     * 启用或禁用用户
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/26 15:54
     */
    Result<Void> forbiddenOrStartUser(UserDO user);

    /**
     * 根据用户编码查询
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/26 21:31
     */
    Result<UserDO> queryByUserCode(String userCode);

    /**
     * 保存用户角色映射
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:12
     **/
    Result<Void> saveUserRoleMapping(String[] funs, String userCode);

}
