$(function () {
    // 页面加载时马上刷新角色列表
    initRoleTable()
})

function initRoleTable() {
    $('#roleTable').bootstrapTable({
        url: "/role/list",
        method: "POST",
        striped: true,
        sidePagination: "server",
        dataType: "json",
        contentType: "application/json",
        pagination: true,
        pageSize: 10,
        pageList: [10, 20, 50, 100],
        smartDisplay: false,
        silentSort: false,
        clickToSelect: true,
        paginationPreText: "上一页",
        paginationNextText: "下一页",
        queryParams: function (params) {
            var temp = {
                pageSize: params.limit,
                currentPage: (params.offset + params.limit) / params.limit,
                orderBy: "create_date desc",
                data: serializeObject($("#queryRoleForm"))
            };
            return JSON.stringify(temp);
        },
        columns: [
            {
                checkbox: true,
                field: 'state'
            }, {
                field: 'roleCode',
                title: '角色编码',
                /*class: 'project-completion',*/
                formatter: function (value, row, index) {
                    return '<span class="label label-info">' + value + '</span>';
                }
            }, {
                field: 'roleName',
                title: '角色名称',
                /*class: 'project-status',*/
                formatter: function (value, row, index) {
                    var span = '';
                    if (value === 'DEFAULT') {
                        span = '<span class="label label-default">' + value + '</span>';
                    } else {
                        span = '<span class="label label-primary">' + value + '</span>';
                    }
                    return span;
                }
            }, {
                field: 'remark',
                title: '备注'
            }, {
                field: 'createUser',
                title: '创建人'
            }, {
                field: 'createDate',
                title: '创建时间',
            }, {
                field: 'id',
                title: '操作',
                formatter: function (value, row, index) {
                    var v1 = '<a href="javascript:void(0);" onclick="javascript:showRoleAllocationModal(\'' + row.roleCode + '\',\'' + row.roleName + '\');" class="btn btn-white btn-sm"><i class="fa fa-folder"></i> 权限分配 </a>';
                    var v2 = '<a href="javascript:void(0);" onclick="javascript:showModifyRoleModal(\'' + row.roleCode + '\',\'' + row.roleName + '\',\'' + row.remark + '\');" class="btn btn-white btn-sm"><i class="fa fa-pencil"></i> 编辑 </a>';
                    var v3 = '<a href="javascript:void(0);" onclick="javascript:deleteRole(\'' + row.roleCode + '\');" class="btn btn-white btn-sm"><i class="fa fa-trash"></i> 删除 </a>';
                    return v1 + v2 + v3;
                }
            }
        ],
    });
}

/**
 * 刷新角色列表
 */
function searchButton() {
    $('#roleTable').bootstrapTable('refresh');
}

/**
 * 弹出角色分配modal
 * @param roleCode  角色编码
 * @param roleName  角色名称
 */
function showRoleAllocationModal(roleCode, roleName) {
    $("#roleAllocationModal").modal('show');
    $("#detailRoleCode").text(roleCode);
    $("#detailRoleName").text(roleName);
    $('#treeFunction').data('jstree', false);
    $('#treeFunction').jstree({
        'plugins': ["checkbox"],
        "checkbox": {
            "three_state": false,//父子级别级联选择
        },
        'core': {
            "multiple": true,
            'data': {
                "url": "/menu/getMenuTree?roleCode=" + roleCode,
                "dataType": "json"
            }
        }
    });
}

/**
 * 保存角色功能映射信息
 */
function saveRoleMapping() {
    // 获得所有选中节点，返回值为数组
    var funs = $('#treeFunction').jstree(true).get_selected(false);
    var role = $("#detailRoleCode").text();
    $.ajax({
        type: "POST",
        dataType: "json",
        url: "/role/saveRoleMapping",
        data: {
            "funs": funs,
            "role": role,
        },
        traditional: true,//这里设置为true
        success: function (result) {
            if (result.success) {
                parent.layer.msg('保存成功', {icon: 1});
            } else {
                parent.layer.msg(result.errorMessage, {icon: 2});
            }
        }
    });
    $("#roleAllocationModal").modal('hide');
}

/**
 * 显示新增角色模块方法
 */
function showAddRoleModal() {
    // 清空表单数据
    $("#roleModifyForm")[0].reset();
    // 发请求获取一个新的角色编码
    $.ajax({
        type: "GET",
        url: "/role/assginCode",
        dataType: "json",
        success: function (result) {
            if (result.success) {
                $("#code").val(result.data);
            } else {
                parent.layer.msg(result.errorMessage, {icon: 2});
            }
        }
    });
}

/**
 * 显示修改角色模块方法
 */
function showModifyRoleModal(roleCode, roleName, remark) {
    // 清空表单数据
    $("#roleModifyForm")[0].reset();
    // 设置角色值
    $("#code").val(roleCode);
    $("#name").val(roleName);
    $("#remark").val(remark);
    // 显示弹框
    $("#roleModifyModal").modal('show');
}

/**
 * 根据角色id删除角色
 * @param id    角色id
 */
function deleteRole(roleCode) {
    parent.layer.confirm('是否确认删除该角色？', {
        btn: ['确认', '取消'], //按钮
        shade: false //不显示遮罩
    }, function () {
        $.ajax({
            type: "GET",
            contentType: 'application/json;charset=utf-8',
            url: "/role/deleteRole?roleCode=" + roleCode,
            dataType: "json",
            success: function (result) {
                if (result.success) {
                    // 保存成功，刷新角色列表
                    searchButton();
                    parent.layer.msg('删除成功', {icon: 1});
                } else {
                    parent.layer.msg(result.errorMessage, {icon: 2});
                }
            }
        });
    }, function () {
    });
}

/**
 * 保存角色
 */
function saveRole() {
    $.ajax({
        type: "POST",
        dataType: "json",
        url: "/role/saveRole",
        data: $('#roleModifyForm').serialize(),
        success: function (result) {
            if (result.success) {
                // 保存成功，刷新角色列表
                searchButton();
                parent.layer.msg('保存成功', {icon: 1});
            } else {
                parent.layer.msg(result.errorMessage, {icon: 2});
            }
        }
    });
    $("#roleModifyModal").modal('hide');
}