$(function () {
    initUserTable();

});

function initUserTable() {
    $('#userTable').bootstrapTable({
        url: "/user/list",
        method: "POST",
        striped: true,
        sidePagination: "server",
        dataType: "json",
        contentType: "application/json",
        pagination: true,
        pageSize: 10,
        pageList: [10, 20, 50, 100],
        smartDisplay: false,
        silentSort: false,
        clickToSelect: true,
        paginationPreText: "上一页",
        paginationNextText: "下一页",
        queryParams: function (params) {
            var temp = {
                pageSize: params.limit,
                currentPage: (params.offset + params.limit) / params.limit,
                orderBy: "create_date desc",
                data: serializeObject($("#queryUserForm"))
            };
            return JSON.stringify(temp);
        },
        columns: [
            {
                checkbox: true,
                field: 'state'
            }, {
                field: 'userCode',
                title: '用户编码',
                /*class: 'project-completion',*/
                formatter: function (value, row, index) {
                    return '<span class="label label-info">' + value + '</span>';
                }
            }, {
                field: 'userName',
                title: '用户名称',
                class: 'project-status',
                formatter: function (value, row, index) {
                    var span = '';
                    if (row.isActive === 'N') {
                        span = '<span class="label label-default">' + value + '</span>';
                    } else {
                        span = '<span class="label label-primary">' + value + '</span>';
                    }
                    return span;
                }
            }, {
                field: 'sign',
                title: '个性签名',
                formatter: function (value, row, index) {
                    return '<span>' + value + '</span>';
                }
            }, {
                field: 'email',
                title: '邮箱',
                formatter: function (value, row, index) {
                    return '<span>' + value + '</span>';
                }
            }, {
                field: 'profile',
                title: '头像',
                align: 'left',
                class: 'project-people',
                formatter: function (value, row, index) {
                    return '<img class="img-circle" src="' + value + '" alt="头像">';
                }
            }, {
                field: 'id',
                title: '操作',
                formatter: function (value, row, index) {
                    var v2 = '';
                    if (row.isActive === 'N') {
                        v2 = '<a href="javascript:void(0);" onclick="javascript:isForbidden(\'' + row.userCode + '\',\'' + row.isActive + '\');" class="btn btn-white btn-sm"><i class="fa fa-toggle-off"></i> 启用 </a>';
                    } else {
                        v2 = '<a href="javascript:void(0);" onclick="javascript:isForbidden(\'' + row.userCode + '\',\'' + row.isActive + '\');" class="btn btn-white btn-sm"><i class="fa fa-toggle-on"></i> 禁用 </a>'
                    }
                    var v1 = '<a href="javascript:void(0);" onclick="javascript:showUserRoleModal(\'' + row.userCode + '\',\'' + row.userName + '\');"class="btn btn-white btn-sm"><i class="fa fa-folder"></i> 角色分配 </a>'
                    return v1 + v2;
                }
            }
        ],
    });
}

/**
 * 刷新角色列表
 */
function searchButton() {
    $('#userTable').bootstrapTable('refresh');
}

/**
 * 启用或禁用用户
 * @param userCode  用户编码
 * @param isActive  是否启用
 */
function isForbidden(userCode, isActive) {
    parent.layer.confirm('是否确认' + (isActive == 'Y' ? '禁用' : '启用') + '该用户？', {
        btn: ['确认', '取消'], //按钮
        shade: false //不显示遮罩
    }, function () {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/user/isForbidden",
            data: {
                userCode: userCode,
                isActive: isActive
            },
            success: function (result) {
                if (result.success) {
                    // 保存成功，刷新角色列表
                    searchButton();
                    parent.layer.msg(isActive == 'Y' ? '禁用成功' : '启用成功', {icon: 1});
                } else {
                    parent.layer.msg(result.errorMessage, {icon: 2});
                }
            }
        });
    }, function () {
    });
}

/**
 * 弹出用户角色分配modal
 * @param roleCode  角色编码
 * @param roleName  角色名称
 */
function showUserRoleModal(userCode, userName) {
    $("#userRoleModal").modal('show');
    $("#detailUserCode").text(userCode);
    $("#detailUserName").text(userName);
    $('#treeFunction').data('jstree', false);
    $('#treeFunction').jstree({
        'plugins': ["checkbox"],
        "checkbox": {
            "three_state": false,//父子级别级联选择
        },
        'core': {
            "multiple": true,
            'data': {
                "url": "/user/getRoleTreeByUserCode?userCode=" + userCode,
                "dataType": "json"
            }
        }
    });
}

/**
 * 保存用户角色映射信息
 */
function saveUserRoleMapping() {
    // 获得所有选中节点，返回值为数组
    var roles = $('#treeFunction').jstree(true).get_selected(false);
    var userCode = $("#detailUserCode").text();
    $.ajax({
        type: "POST",
        dataType: "json",
        url: "/user/saveUserRoleMapping",
        data: {
            "roles": roles,
            "userCode": userCode,
        },
        traditional: true,//这里设置为true
        success: function (result) {
            if (result.success) {
                parent.layer.msg('保存成功', {icon: 1});
            } else {
                parent.layer.msg(result.errorMessage, {icon: 2});
            }
        }
    });
    $("#userRoleModal").modal('hide');
}