/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.common.dao.Result;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="adminLoginController")
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ResponseBody
    public Object login(@RequestParam String userCode, @RequestParam String password) {
        Result result = new Result();
        try {
            if (StringUtils.isBlank((CharSequence)userCode) || StringUtils.isBlank((CharSequence)password)) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
                return result;
            }
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isAuthenticated()) {
                UsernamePasswordToken token = new UsernamePasswordToken(userCode, password);
                token.setRememberMe(true);
                try {
                    subject.login((AuthenticationToken)token);
                    subject.getSession().setAttribute((Object)"userCode", (Object)userCode);
                    return result;
                }
                catch (IncorrectCredentialsException e) {
                    result.setErrorMessage("\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff01");
                }
                catch (ExcessiveAttemptsException e) {
                    result.setErrorMessage("\u767b\u5f55\u5931\u8d25\u6b21\u6570\u8fc7\u591a!");
                }
                catch (LockedAccountException e) {
                    result.setErrorMessage("\u5e10\u53f7\u5df2\u88ab\u9501\u5b9a!");
                }
                catch (DisabledAccountException e) {
                    result.setErrorMessage("\u5e10\u53f7\u5df2\u88ab\u7981\u7528!");
                }
                catch (ExpiredCredentialsException e) {
                    result.setErrorMessage("\u5e10\u53f7\u5df2\u8fc7\u671f!");
                }
                catch (UnknownAccountException e) {
                    result.setErrorMessage("\u5e10\u53f7\u4e0d\u5b58\u5728!");
                }
                catch (UnauthorizedException e) {
                    result.setErrorMessage("\u60a8\u6ca1\u6709\u5f97\u5230\u76f8\u5e94\u7684\u6388\u6743!");
                }
                catch (Exception e) {
                    result.setErrorMessage("\u51fa\u9519:" + e.getMessage());
                }
                result.setSuccess(Boolean.FALSE.booleanValue());
                logger.error(result.getErrorMessage());
                return result;
            }
            return result;
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u767b\u5f55\u5f02\u5e38\uff1a" + e);
            logger.error(result.getErrorMessage());
            return result;
        }
    }

    @RequestMapping(value={"/logout"})
    public String main() {
        Subject currentUser = SecurityUtils.getSubject();
        currentUser.logout();
        return "admin-boot/login";
    }
}

