/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.constants.DefaultRoleConstants;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.service.RoleService;
import com.naivete.framework.common.constant.MargicNumberConstants;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import com.naivete.framework.common.util.PageUtils;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="adminRoleController")
@RequestMapping(value={"/role"})
public class RoleController {
    private static final Logger logger = LoggerFactory.getLogger(RoleController.class);
    @Resource
    private RoleService adminRoleService;

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public Object list(@RequestBody Query<RoleDO> query) {
        ResultList<RoleDO> resultList = this.adminRoleService.queryList(query);
        return PageUtils.resultJSON(resultList);
    }

    @ResponseBody
    @RequestMapping(value={"/saveRoleMapping"}, method={RequestMethod.POST})
    public Object saveRoleMapping(String[] funs, String role) {
        Result<Void> result = new Result<Void>();
        if (StringUtils.isEmpty((Object)role)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        result = this.adminRoleService.saveRoleMapping(funs, role);
        if (!result.isSuccess()) {
            logger.error("\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff1a" + result.getErrorMessage());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/assginCode"}, method={RequestMethod.GET})
    public Result<String> assginCode(HttpServletRequest request) {
        Result result = new Result();
        try {
            Result<RoleDO> roleResult = this.adminRoleService.queryMostBigRoleCode();
            if (!roleResult.isSuccess() || null == roleResult.getData()) {
                result.setErrorMessage("\u6ca1\u6709\u67e5\u8be2\u5230\u7f16\u7801\u6700\u5927\u7684\u89d2\u8272\uff01");
                result.setSuccess(Boolean.FALSE.booleanValue());
                logger.error("\u751f\u6210\u89d2\u8272\u7f16\u7801\u5931\u8d25\uff1a" + result.getErrorMessage());
                return result;
            }
            String roleCode = ((RoleDO)roleResult.getData()).getRoleCode();
            roleCode = roleCode.replace("R", "").trim();
            roleCode = String.valueOf(Integer.parseInt(roleCode) + 1);
            roleCode = "00000" + roleCode;
            roleCode = "R" + roleCode.substring(roleCode.length() - MargicNumberConstants.n5, roleCode.length());
            String currentUserCode = (String)request.getSession().getAttribute("userCode");
            RoleDO role = new RoleDO();
            role.setRoleName(DefaultRoleConstants.DEFAULT.name());
            role.setRemark(DefaultRoleConstants.DEFAULT.getCname());
            role.setRoleCode(roleCode);
            role.setCreateDate(new Date());
            role.setCreateUser(currentUserCode);
            Result<Void> addResult = this.adminRoleService.addOne(role);
            if (!addResult.isSuccess()) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(addResult.getErrorMessage());
                logger.error(result.getErrorMessage());
                return result;
            }
            result.setData((Object)roleCode);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u751f\u6210\u89d2\u8272\u7f16\u7801\u5f02\u5e38\uff01");
            logger.error(result.getErrorMessage() + e);
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteRole"}, method={RequestMethod.GET})
    public Result<Void> deleteRole(String roleCode) {
        return this.adminRoleService.removeRoleByRoleCode(roleCode);
    }

    @ResponseBody
    @RequestMapping(value={"/saveRole"}, method={RequestMethod.POST})
    public Result<Void> saveRole(HttpServletRequest request, RoleDO role) {
        Result<Void> result = new Result<Void>();
        if (null == role) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u4fe1\u606f\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isEmpty((Object)role.getRoleName())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u540d\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isEmpty((Object)role.getRoleCode())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            String currentUserCode = (String)request.getSession().getAttribute("userCode");
            role.setModifyDate(new Date());
            role.setModifyUser(currentUserCode);
            result = this.adminRoleService.modify(role);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }
}

