/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.model.RoleTree;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.service.RoleService;
import com.naivete.framework.admin.boot.service.UserService;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import com.naivete.framework.common.util.PageUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="adminUserController")
@RequestMapping(value={"/user"})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Resource
    private UserService adminUserService;
    @Resource
    private RoleService adminRoleService;

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public Object list(@RequestBody Query<UserDO> query) {
        ResultList<UserDO> resultList = this.adminUserService.queryList(query);
        return PageUtils.resultJSON(resultList);
    }

    @ResponseBody
    @RequestMapping(value={"/isForbidden"}, method={RequestMethod.POST})
    public Result<Void> isForbidden(UserDO user) {
        return this.adminUserService.forbiddenOrStartUser(user);
    }

    @ResponseBody
    @RequestMapping(value={"/getRoleTreeByUserCode"}, method={RequestMethod.GET})
    public List<RoleTree> getRoleTreeByUserCode(@RequestParam String userCode) {
        ArrayList<RoleTree> list = new ArrayList<RoleTree>();
        ResultList<RoleDO> userRoleResult = this.adminRoleService.queryListByUserCode(userCode);
        List userRoleList = (List)userRoleResult.getDatalist();
        ResultList<RoleDO> roleResult = this.adminRoleService.queryAll();
        List roleList = (List)roleResult.getDatalist();
        for (RoleDO role : roleList) {
            RoleTree roleTree = new RoleTree();
            roleTree.initState(Boolean.TRUE, Boolean.FALSE);
            for (RoleDO userRole : userRoleList) {
                if (!role.getRoleCode().equals(userRole.getRoleCode())) continue;
                roleTree.initState(Boolean.TRUE, Boolean.TRUE);
                break;
            }
            roleTree.setId(role.getRoleCode());
            roleTree.setText(role.getRoleName());
            list.add(roleTree);
        }
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"/saveUserRoleMapping"}, method={RequestMethod.POST})
    public Object saveRoleMapping(String[] roles, String userCode) {
        Result<Void> result = new Result<Void>();
        if (StringUtils.isEmpty((Object)userCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u7528\u6237\u89d2\u8272\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u4e3a\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        result = this.adminUserService.saveUserRoleMapping(roles, userCode);
        if (!result.isSuccess()) {
            logger.error("\u4fdd\u5b58\u7528\u6237\u89d2\u8272\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff1a" + result.getErrorMessage());
        }
        return result;
    }
}

