/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.service.impl;

import com.naivete.framework.admin.boot.dao.FunctionDAO;
import com.naivete.framework.admin.boot.dao.FunctionRoleMappingDAO;
import com.naivete.framework.admin.boot.dao.RoleDAO;
import com.naivete.framework.admin.boot.dao.UserDAO;
import com.naivete.framework.admin.boot.dao.UserRoleMappingDAO;
import com.naivete.framework.admin.boot.model.AuthInfoDO;
import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.service.AuthInfoService;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import com.naivete.framework.common.util.MD5Utils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="adminAuthInfoService")
public class AuthInfoServiceImpl
implements AuthInfoService {
    private static Logger logger = LoggerFactory.getLogger(AuthInfoServiceImpl.class);
    @Resource
    private UserDAO userDAO;
    @Resource
    private RoleDAO roleDAO;
    @Resource
    private UserRoleMappingDAO userRoleMappingDAO;
    @Resource
    private FunctionDAO functionDAO;
    @Resource
    private FunctionRoleMappingDAO functionRoleMappingDAO;

    @Override
    public Result<AuthInfoDO> queryAuthInfoByUserCode(String userCode) {
        Result result = new Result();
        AuthInfoDO authInfo = new AuthInfoDO();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u4e3a\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            UserDO user = this.userDAO.selectOneByUserCode(userCode);
            if (null == user) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u67e5\u8be2\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u65e0\u6548\uff01");
                logger.error(result.getErrorMessage());
                return result;
            }
            authInfo.setUser(user);
            List<String> roleCodes = this.userRoleMappingDAO.selectListByUserCode(userCode);
            if (CollectionUtils.isEmpty(roleCodes)) {
                logger.error("\u6ca1\u6709\u4efb\u4f55\u89d2\u82721");
                result.setData((Object)authInfo);
                return result;
            }
            List<RoleDO> roleList = this.roleDAO.selectListByRoleCode(roleCodes);
            authInfo.setRoleList(roleList);
            if (CollectionUtils.isEmpty(roleList)) {
                logger.error("\u6ca1\u6709\u4efb\u4f55\u89d2\u82722");
                result.setData((Object)authInfo);
                return result;
            }
            List<String> functionCodes = this.functionRoleMappingDAO.selectListByRoleCode(roleCodes);
            if (CollectionUtils.isEmpty(functionCodes)) {
                logger.error("\u6ca1\u6709\u4efb\u4f55\u529f\u80fd1");
                result.setData((Object)authInfo);
                return result;
            }
            List<FunctionDO> functionList = this.functionDAO.selectListByFunctionCode(functionCodes);
            authInfo.setFunctionList(functionList);
            if (CollectionUtils.isEmpty(roleList)) {
                logger.error("\u6ca1\u6709\u4efb\u4f55\u529f\u80fd2");
                result.setData((Object)authInfo);
                return result;
            }
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage() + e.getMessage());
            return result;
        }
        result.setData((Object)authInfo);
        return result;
    }

    @Override
    public Result<UserDO> login(String userCode, String password) {
        Result result = new Result();
        if (StringUtils.isEmpty((CharSequence)userCode) || StringUtils.isEmpty((CharSequence)password)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u7528\u6237\u540d\u6216\u5bc6\u7801\u7a7a!");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            password = MD5Utils.password((String)password);
            UserDO u = new UserDO();
            u.setUserCode(userCode);
            u.setPassword(password);
            UserDO user = this.userDAO.selectOneByLogin(u);
            if (null == user) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u7528\u6237\u540d\u6216\u5bc6\u7801\u7a7a!");
                logger.error(result.getErrorMessage());
                return result;
            }
            result.setData((Object)user);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u767b\u5f55\u9a8c\u8bc1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage() + e.getMessage());
            return result;
        }
        return result;
    }

    @Override
    public ResultList<String> queryRoleCodeByUserCode(String userCode) {
        ResultList result = new ResultList();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            List<String> roleCodes = this.userRoleMappingDAO.selectListByUserCode(userCode);
            result.setDatalist(roleCodes);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }
}

