/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.service.impl;

import com.naivete.framework.admin.boot.dao.FunctionRoleMappingDAO;
import com.naivete.framework.admin.boot.dao.RoleDAO;
import com.naivete.framework.admin.boot.dao.UserRoleMappingDAO;
import com.naivete.framework.admin.boot.model.FunctionRoleMappingDO;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.service.RoleService;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Service(value="adminRoleService")
public class RoleServiceImpl
implements RoleService {
    private static Logger logger = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Resource
    private RoleDAO roleDAO;
    @Resource
    private FunctionRoleMappingDAO functionRoleMappingDAO;
    @Resource
    private UserRoleMappingDAO userRoleMappingDAO;
    @Resource
    private TransactionTemplate transactionTemplate;

    @Override
    public ResultList<RoleDO> queryList(Query<RoleDO> query) {
        ResultList result = new ResultList();
        if (null == query || null == query.getData()) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u89d2\u8272\u5931\u8d25\uff0c\u53c2\u6570\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            result.setTotal(this.roleDAO.selectListCount(query));
            result.setDatalist((Collection)this.roleDAO.selectList(query));
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u89d2\u8272\u5f02\u5e38," + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public ResultList<RoleDO> queryListByUserCode(String userCode) {
        ResultList result = new ResultList();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u5931\u8d25\uff0c\u53c2\u6570\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            List<String> roleCodes = this.userRoleMappingDAO.selectListByUserCode(userCode);
            if (!CollectionUtils.isEmpty(roleCodes)) {
                result.setDatalist(this.roleDAO.selectListByRoleCode(roleCodes));
            }
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u5f02\u5e38," + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public ResultList<RoleDO> queryAll() {
        ResultList result = new ResultList();
        try {
            result.setDatalist(this.roleDAO.selectAll());
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6240\u6709\u89d2\u8272\u5f02\u5e38," + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public Result<Void> saveRoleMapping(String[] funs, String role) {
        if (StringUtils.isBlank((CharSequence)role)) {
            return new Result();
        }
        return (Result)this.transactionTemplate.execute(status -> {
            Result result = new Result();
            try {
                this.functionRoleMappingDAO.deleteByRole(role);
                if (null != funs && funs.length > 0) {
                    ArrayList<FunctionRoleMappingDO> list = new ArrayList<FunctionRoleMappingDO>();
                    for (int i = 0; i < funs.length; ++i) {
                        FunctionRoleMappingDO mapping = new FunctionRoleMappingDO();
                        mapping.setFunctionCode(funs[i]);
                        mapping.setRoleCode(role);
                        list.add(mapping);
                    }
                    this.functionRoleMappingDAO.insertBatch(list);
                }
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                status.setRollbackOnly();
                logger.error(result.getErrorMessage());
            }
            return result;
        });
    }

    @Override
    public Result<Void> addOne(RoleDO role) {
        Result result = new Result();
        try {
            int num = this.roleDAO.insert(role);
            if (num != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u6dfb\u52a0\u5355\u6761\u89d2\u8272\u4fe1\u606f\u5931\u8d25\u53d7\u5f71\u54cd\u884c\u4e0d\u7b49\u4e8e1\uff01");
                logger.error(result.getErrorMessage());
            }
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6dfb\u52a0\u5355\u6761\u89d2\u8272\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    @Override
    public Result<RoleDO> queryMostBigRoleCode() {
        Result result = new Result();
        try {
            RoleDO role = this.roleDAO.selectMostBigRoleCode();
            result.setData((Object)role);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u89d2\u8272\u7f16\u7801\u6700\u5927\u7684\u4e00\u6761\u89d2\u8272\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    @Override
    public Result<Void> removeRoleByRoleCode(String roleCode) {
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u5220\u9664\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272ID\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        return (Result)this.transactionTemplate.execute(status -> {
            Result result1 = new Result();
            try {
                this.roleDAO.deleteByRoleCode(roleCode);
                this.functionRoleMappingDAO.deleteByRole(roleCode);
                this.userRoleMappingDAO.deleteByRole(roleCode);
            }
            catch (Exception e) {
                result1.setSuccess(Boolean.FALSE.booleanValue());
                result1.setErrorMessage("\u5220\u9664\u89d2\u8272\u5f02\u5e38\uff1a" + e.getMessage());
                logger.error(result1.getErrorMessage());
                status.setRollbackOnly();
            }
            return result1;
        });
    }

    @Override
    public Result<Void> modify(RoleDO role) {
        Result result = new Result();
        try {
            this.roleDAO.update(role);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u66f4\u65b0\u89d2\u8272\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }
}

