var selectedFun = null;

$(document).ready(function () {
    $('#using_json').jstree({
        'core': {
            'data': {
                "url": "/menu/getMenuTree",
                "dataType": "json"
            }
        }
    }).on('changed.jstree', function (e, data) {
        if (data.instance.get_node(data.selected[0]).data) {
            selectedFun = data.instance.get_node(data.selected[0]).data;
            $("#code").val(selectedFun.code);
            $("#name").val(selectedFun.name);
            $("#parentCode").val(selectedFun.parentCode);
            $("#parentName").val(selectedFun.parentName);
            $("#url").val(selectedFun.url);
            $("#icon").val(selectedFun.icon);
            $("#level").val(selectedFun.level);
            switch (selectedFun.type) {
                case 'FOLDER':
                    $("#type").val('文件夹');
                    break;
                case 'MENU':
                    $("#type").val('菜单');
                    break;
                case 'BUTTON':
                    $("#type").val('按钮');
                    break;
                default:
                    $("#type").val(selectedFun.type);
            }
            reloadTable();
        }
    });

    $('#showAddFun').click(function () {
        $("#mCode").val(null);
        $("#mName").val(null);
        $("#mParentCode").val(null);
        $("#mParentName").val(null);
        $("#mUrl").val(null);
        $("#mType").val("MENU");
        $("#mIcon").val(null);
        $("#mLevel").val(null);
        if (null == selectedFun) {
            $("#mParentCode").val(0);
            $("#mParentName").val('Naivete');
            $("#mLevel").val(1);
            $('#mIcon').removeAttr("readonly");
            $("#mName").removeAttr("readonly");
            $("#mUrl").removeAttr("readonly");
            $("#mType").removeAttr("readonly");
        } else {
            $("#mName").removeAttr("readonly");
            $("#mParentCode").val(selectedFun.code);
            $("#mParentName").val(selectedFun.name);
            $("#mUrl").removeAttr("readonly");
            $("#mType").removeAttr("readonly");
            $("#mIcon").removeAttr("readonly");
            $("#mLevel").val(parseInt(selectedFun.level) + parseInt(1));
        }
        var parentCode = selectedFun == null ? 0 : selectedFun.code;
        $.ajax({
            type: "GET",
            url: "/menu/assginCode?parentCode=" + parentCode,
            dataType: "json",
            success: function (data) {
                $("#mCode").val(data.data);
            }
        });
    });

    $('#showModifyFun').click(function () {
        if (selectedFun) {
            $("#mCode").val(selectedFun.code);
            $("#mName").val(selectedFun.name);
            $("#mParentCode").val(selectedFun.parentCode);
            $("#mParentName").val(selectedFun.parentName);
            $("#mUrl").val(selectedFun.url);
            $("#mType").val(selectedFun.type);
            $("#mIcon").val(selectedFun.icon);
            $("#mLevel").val(selectedFun.level);
            $("#mName").removeAttr("readonly");
            $("#mUrl").removeAttr("readonly");
            $("#mType").removeAttr("readonly");
            $("#mIcon").removeAttr("readonly");
            $("#myModal").modal('show');
        } else {
            parent.layer.msg('请选择要修改的数据！', {icon: 0});
        }
    });

    $('#saveFun').click(function () {
        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/menu/saveFun",
            data: $('#mForm').serialize(),
            success: function (result) {
                if (result.success) {
                    // 保存成功，重新加载树和子功能
                    $('#using_json').jstree(true).refresh();
                    reloadTable();
                    parent.layer.msg('保存成功', {icon: 1});
                } else {
                    parent.layer.msg(result.errorMessage, {icon: 2});
                }
            }
        });
        $("#myModal").modal('hide');
    });

    $('#showDeleteFun').click(function () {
        var code = $("#code").val();
        if (code == null || code == "") {
            parent.layer.msg('请选择要删除的数据！', {icon: 0});
            return;
        }
        parent.layer.confirm('是否确认删除该功能及子功能？', {
            btn: ['确认', '取消'], //按钮
            shade: false //不显示遮罩
        }, function () {
            $.ajax({
                type: "GET",
                contentType: 'application/json;charset=utf-8',
                url: "/menu/deleteFun?code=" + $("#code").val(),
                dataType: "json",
                success: function (data) {
                    if (data.success) {
                        // 保存成功，重新加载树和子功能
                        $('#using_json').jstree(true).refresh();
                        reloadTable();
                        parent.layer.msg('删除成功', {icon: 1});
                    } else {
                        parent.layer.msg(data.errorMessage, {icon: 2});
                    }
                }
            });
        }, function () {
        });
    });

});

/**
 * 加载子功能
 */
function reloadTable() {
    if (!selectedFun || !selectedFun.code) {
        return;
    }
    $.ajax({
        type: "GET",
        url: "/menu/lodSubFun?parentCode=" + selectedFun.code,
        dataType: "json",
        success: function (json) {
            $("#subFunTable").bootstrapTable('load', json);
        }
    });
}