package com.naivete.framework.common.dao;


import com.naivete.framework.common.constant.MargicNumberConstants;

import java.util.Date;

/**
 * 分页模型，用于查询列表时进行分页
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/1 11:19
 **/
public class Paginator {

    /**
     * 每页显示条数
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private int limit = MargicNumberConstants.n20;

    /**
     * 起始行号
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long start = MargicNumberConstants.n0;

    /**
     * 结束行号
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long end = MargicNumberConstants.n20;

    /**
     * 总数
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long total = MargicNumberConstants.n0;

    /**
     * 时间戳
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private Date timestamp;

    /**
     * 当前页
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long index = MargicNumberConstants.n1;

    /**
     * 总页数
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long pageNum = MargicNumberConstants.n0;

    /**
     * ...隔开的中间页码数量
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private int breakpage = MargicNumberConstants.n5;

    /**
     * ...隔开的中间页码序列中间位置，从零开始
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long currentposition = MargicNumberConstants.n2;

    /**
     * ...隔开的两端页码数量
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private int breakspace = MargicNumberConstants.n2;

    /**
     * 是否用...断开的判断数量
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private int maxspace = MargicNumberConstants.n4;

    /**
     * prevnum
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long prevnum;

    /**
     * nextnum
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long nextnum;

    /**
     * Paginator
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public Paginator() {

    }

    /**
     * Paginator
     * 初始化分页类，生成可供查询使用的分页类
     *
     * @param index
     * @param limit
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public Paginator(int index, int limit) {
        if (index < MargicNumberConstants.n0) {
            this.setIndex(MargicNumberConstants.n1);
        }
        /**
         * setIndex
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setIndex(index);
        /**
         * setLimit
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setLimit(limit);
        /**
         * setStart
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setStart((this.getIndex() - MargicNumberConstants.n1) * this.getLimit());
        /**
         * setEnd
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setEnd(this.getIndex() * this.getLimit());
    }

    /**
     * generateView
     * 完成查询得道结果后，使用此方法生成供页面展示分页控件的分页类
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void generateView() {
        this.setPageNum(new Double(Math.ceil(new Double(total) / this.getLimit())).intValue());

        if (this.getIndex() > this.getPageNum()) {
            this.setIndex(this.getPageNum());
        }

        /**
         * setPrevnum
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setPrevnum(this.getIndex() - this.getCurrentposition());
        /**
         * setNextnum
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setNextnum(this.getIndex() + this.getCurrentposition());
        /**
         * getPrevnum
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        if (this.getPrevnum() < MargicNumberConstants.n1) {
            this.setPrevnum(MargicNumberConstants.n1);
        }
        /**
         * getNextnum
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        if (this.getNextnum() > this.getPageNum()) {
            this.setNextnum(this.getPageNum());
        }
        /**
         * setEnd
         * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
         */
        this.setEnd(Math.min(this.getIndex() * this.getLimit(), this.getTotal()));
    }

    /**
     * getLimit
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getLimit() {
        return limit;
    }

    /**
     * setLimit
     *
     * @param limit
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setLimit(int limit) {
        this.limit = limit;
        this.setStart((this.getIndex() - MargicNumberConstants.n1) * this.getLimit());
        this.setEnd(this.getIndex() * this.getLimit());
    }

    /**
     * getStart
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getStart() {
        return start;
    }

    /**
     * setStart
     *
     * @param start
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setStart(long start) {
        this.start = start;
    }

    /**
     * getEnd
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getEnd() {
        return end;
    }

    /**
     * setEnd
     *
     * @param end
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setEnd(long end) {
        this.end = end;
    }

    /**
     * getTotal
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getTotal() {
        return total;
    }

    /**
     * setTotal
     *
     * @param total
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setTotal(long total) {
        this.total = total;
    }

    /**
     * getIndex
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public Long getIndex() {
        return index;
    }

    /**
     * setIndex
     *
     * @param index
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setIndex(long index) {
        if (index < MargicNumberConstants.n1) {
            index = MargicNumberConstants.n1;
        }
        this.index = index;
        this.setStart((this.getIndex() - MargicNumberConstants.n1) * this.getLimit());
        this.setEnd(this.getIndex() * this.getLimit());
    }

    /**
     * getPageNum
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getPageNum() {
        return pageNum;
    }

    /**
     * setPageNum
     *
     * @param pageNum
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * getBreakpage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getBreakpage() {
        return breakpage;
    }

    /**
     * setBreakpage
     *
     * @param breakpage
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setBreakpage(int breakpage) {
        this.breakpage = breakpage;
    }

    /**
     * getCurrentposition
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getCurrentposition() {
        return currentposition;
    }

    /**
     * setCurrentposition
     *
     * @param currentposition
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setCurrentposition(int currentposition) {
        this.currentposition = currentposition;
    }

    /**
     * getBreakspace
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getBreakspace() {
        return breakspace;
    }

    /**
     * setBreakspace
     *
     * @param breakspace
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setBreakspace(int breakspace) {
        this.breakspace = breakspace;
    }

    /**
     * getMaxspace
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getMaxspace() {
        return maxspace;
    }

    /**
     * setMaxspace
     *
     * @param maxspace
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setMaxspace(int maxspace) {
        this.maxspace = maxspace;
    }

    /**
     * getPrevnum
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getPrevnum() {
        return prevnum;
    }

    /**
     * setPrevnum
     *
     * @param prevnum
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setPrevnum(long prevnum) {
        this.prevnum = prevnum;
    }

    /**
     * getNextnum
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getNextnum() {
        return nextnum;
    }

    /**
     * setNextnum
     *
     * @param nextnum
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setNextnum(long nextnum) {
        this.nextnum = nextnum;
    }

    /**
     * isBreakLeft
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean isBreakLeft() {
        return this.getPrevnum() - this.getBreakspace() > this.getMaxspace() ? true : false;
    }

    /**
     * isBreakRight
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean isBreakRight() {
        return this.getPageNum() - this.getBreakspace() - this.getNextnum() + 1 > this.getMaxspace() ? true : false;
    }

    /**
     * getTimestamp
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /**
     * setTimestamp
     *
     * @param timestamp
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }


}
