package com.naivete.framework.common.dao;

import com.naivete.framework.common.constant.MargicNumberConstants;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * QueryBase
 * 传入pageSize,currentPage,total;计算start,end
 *
 * @author JETLEE
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 */
public class QueryBase {

    private static int DEFAULT_PAGE_SIZE = MargicNumberConstants.n20;

    /**
     * pageSize
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */

    protected int pageSize = DEFAULT_PAGE_SIZE;
    /**
     * currentPage
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    protected int currentPage = MargicNumberConstants.n1;
    /**
     * total
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    protected long total;

    /**
     * start
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    protected int start = MargicNumberConstants.n0;

    /**
     * end
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    protected int end = MargicNumberConstants.n20;

    /**
     * getTotal
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */

    public long getTotal() {
        return total;
    }

    /**
     * setTotal
     *
     * @param total
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setTotal(long total) {
        this.total = total;
    }

    /**
     * getPageSize
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * setPageSize
     *
     * @param pageSize
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setPageSize(Integer pageSize) {
        if (pageSize != null && pageSize > MargicNumberConstants.n0) {
            this.pageSize = pageSize;
        }
        this.setStartAndEnd();
    }

    /**
     * getCurrentPage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getCurrentPage() {
        return currentPage;
    }

    /**
     * setCurrentPage
     *
     * @param currentPage
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setCurrentPage(Integer currentPage) {
        if (currentPage != null && currentPage > MargicNumberConstants.n0) {
            this.currentPage = currentPage;
        }
        this.setStartAndEnd();
    }

    /**
     * setStartAndEnd
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    protected void setStartAndEnd() {
        this.start = (this.getCurrentPage() - MargicNumberConstants.n1) * this.getPageSize();
        if (this.start < MargicNumberConstants.n0) {
            this.start = MargicNumberConstants.n0;
        }
        this.end = this.getStart() + this.getPageSize() - MargicNumberConstants.n1;
    }

    /**
     * getStart
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getStart() {
        return start;
    }

    /**
     * setStart
     *
     * @param start
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setStart(Integer start) {
        if (start != null && start >= MargicNumberConstants.n0) {
            this.start = start;
        }
    }

    /**
     * getEnd
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getEnd() {
        return end;
    }

    /**
     * setEnd
     *
     * @param end
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setEnd(Integer end) {
        if (end != null && end >= MargicNumberConstants.n0) {
            this.end = end;
        }
    }

    /**
     * hasNextPage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean hasNextPage() {
        return getCurrentPage() < getTotalPage() - MargicNumberConstants.n1;
    }

    /**
     * hasPreviousPage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean hasPreviousPage() {
        return getCurrentPage() > MargicNumberConstants.n1;
    }

    /**
     * getTotalPage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getTotalPage() {
        if (total % (long) pageSize == MargicNumberConstants.n0)
            return total / (long) pageSize;
        else
            return total / (long) pageSize + MargicNumberConstants.n1;
    }

    /**
     * toString
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

}
