package com.naivete.framework.common.dao;

import com.naivete.framework.common.constant.MargicNumberConstants;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.ArrayList;
import java.util.Collection;

/**
 * ResultList
 *
 * @param <T>
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 */
public class ResultList<T> extends Result<T> {

    /**
     * serialVersionUID
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private static final long serialVersionUID = -8793824978794414238L;
    /**
     * DEFAULT_PAGE_SIZE
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private static int DEFAULT_PAGE_SIZE = MargicNumberConstants.n20;
    /**
     * datalist
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private Collection<T> datalist;
    /**
     * total
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long total = MargicNumberConstants.n0;
    /**
     * pageSize
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private int pageSize;
    /**
     * start
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    private long start;

    /**
     * ResultList
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public ResultList() {
        this(MargicNumberConstants.n0, MargicNumberConstants.n0, DEFAULT_PAGE_SIZE, new ArrayList<T>());
    }

    /**
     * ResultList
     *
     * @param start
     * @param totalSize
     * @param pageSize
     * @param data
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public ResultList(long start, long totalSize, int pageSize, Collection<T> data) {
        this.pageSize = pageSize;
        this.start = start;
        this.total = totalSize;
        this.datalist = data;
    }

    /**
     * getStartOfPage
     *
     * @param pageNo
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    protected static int getStartOfPage(int pageNo) {
        return getStartOfPage(pageNo, DEFAULT_PAGE_SIZE);
    }

    /**
     * getStartOfPage
     *
     * @param pageNo
     * @param pageSize
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public static int getStartOfPage(int pageNo, int pageSize) {
        return (pageNo - 1) * pageSize;
    }

    /**
     * Collection
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public Collection<T> getDatalist() {
        return this.datalist;
    }

    /**
     * setDatalist
     *
     * @param data
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setDatalist(Collection<T> data) {
        this.datalist = data;
    }

    /**
     * getTotal
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getTotal() {
        return total;
    }

    /**
     * setTotal
     *
     * @param total
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setTotal(long total) {
        this.total = total;
    }

    /**
     * getTotalPageCount
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getTotalPageCount() {
        if (total % (long) pageSize == MargicNumberConstants.n0)
            return total / (long) pageSize;
        else
            return total / (long) pageSize + MargicNumberConstants.n1;
    }

    /**
     * getPageSize
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * getCurrentPageNo
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public long getCurrentPageNo() {
        return start / (long) pageSize + MargicNumberConstants.n1;
    }

    /**
     * hasNextPage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean hasNextPage() {
        return getCurrentPageNo() < getTotalPageCount() - MargicNumberConstants.n1;
    }

    /**
     * hasPreviousPage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean hasPreviousPage() {
        return getCurrentPageNo() > MargicNumberConstants.n1;
    }

    /**
     * getPaginator
     *
     * @param currentPage
     * @param pageSize
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public Paginator getPaginator(Integer currentPage, Integer pageSize) {
        if (null == currentPage) {
            currentPage = MargicNumberConstants.n1;
        }
        if (null == pageSize) {
            pageSize = MargicNumberConstants.n20;
        }
        Paginator paginator = new Paginator(currentPage, pageSize);
        paginator.setTotal(total);
        paginator.generateView();
        return paginator;
    }

    /**
     * toString
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
