package com.naivete.framework.common.model;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * ErrorResult
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/1 10:51
 **/
public class ErrorResult implements Serializable {

    // GENERAL_CODE
    public static final int GENERAL_CODE = 999;
    // GENERAL_NAME
    public static final String GENERAL_NAME = "SERVICE_ERROR";
    private static final long serialVersionUID = 2310625057697643584L;
    // errorCode
    private int errorCode;

    // errorName
    private String errorName;

    // errorMessage
    private String errorMessage;

    /**
     * ErrorResult
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     **/
    public ErrorResult() {
        this(GENERAL_CODE, GENERAL_NAME, null);
    }


    /**
     * ErrorResult
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public ErrorResult(int code, String name, String message) {
        this.setError(code, name, message);
    }

    /**
     * setError
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setError(int code, String name, String message) {
        this.errorCode = code;
        this.errorName = name;
        this.errorMessage = message;
    }

    /**
     * setError
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     **/
    public void setError(String name, String message) {
        this.setError(GENERAL_CODE, name, message);
    }


    /**
     * hasError
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public boolean hasError() {
        return StringUtils.isNotBlank(this.errorMessage) && StringUtils.isNotBlank(this.errorName);
    }


    /**
     * getErrorCode
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public int getErrorCode() {
        return errorCode;
    }

    /**
     * setErrorCode
     *
     * @param errorCode
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * getErrorName
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public String getErrorName() {
        return errorName;
    }

    /**
     * setErrorName
     *
     * @param errorName
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setErrorName(String errorName) {
        this.errorName = errorName;
    }

    /**
     * getErrorMessage
     *
     * @return
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * setErrorMessage
     *
     * @param errorMessage
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

}
