package com.naivete.framework.common.util;

import com.naivete.framework.common.constant.MargicNumberConstants;

import java.security.MessageDigest;

/**
 * MD5Utils
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 23:30
 **/
public class MD5Utils {

    /**
     * md5LowerCase
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:30
     **/
    public final static String md5(String s) {
        char hexDigits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            // 获得MD5摘要算法的 MessageDigest 对象
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            // 使用指定的字节更新摘要
            mdInst.update(btInput);
            // 获得密文
            byte[] md = mdInst.digest();
            // 把密文转换成十六进制的字符串形式
            int j = md.length;
            char str[] = new char[j * MargicNumberConstants.n2];
            int k = MargicNumberConstants.n0;

            for (int i = MargicNumberConstants.n0; i < j; i++) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> MargicNumberConstants.n4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(str);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * md5LowerCase
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:30
     **/
    public final static String md5LowerCase(String s) {
        return MD5Utils.md5(s).toLowerCase();
    }


    /**
     * password
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:30
     **/
    public final static String password(String s) {
        return MD5Utils.md5LowerCase(MD5Utils.md5LowerCase(s));
    }

    /**
     * main
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:31
     **/
    public static void main(String[] args) {
        /**
         * println
         */
        System.out.println(MD5Utils.md5(MD5Utils.md5("123456").toLowerCase()));

        /**
         * println
         */
        System.out.println(MD5Utils.md5("加密"));
        System.out.println(MD5Utils.password("admin"));
    }
}