package com.naivete.framework.common.util;

import com.naivete.framework.common.constant.MargicNumberConstants;
import com.naivete.framework.common.dao.ResultList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.util.*;

/**
 * PageUtils
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/11 1:37
 **/
public class PageUtils implements Serializable {

    private static final long serialVersionUID = 7094384198859289182L;

    private static final String PAGE_TOTAL = "total";
    private static final String PAGE_ROWS = "rows";

    /**
     * Controller 封装中台返回值
     */
    public static Object resultJSON(ResultList resultList) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtils.notEqual(null, resultList)) {
            if (resultList.getTotal() > 0) {
                map.put(PAGE_TOTAL, resultList.getTotal());
                map.put(PAGE_ROWS, resultList.getDatalist());
                return map;
            }
        }
        map.put(PAGE_TOTAL, MargicNumberConstants.n0);
        map.put(PAGE_ROWS, new ArrayList<>());
        return map;
    }

    /**
     * Controller 封装中台返回值
     */
    public static Object resultJSON(List list) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(list)) {
            map.put(PAGE_TOTAL, list.size());
            map.put(PAGE_ROWS, list);
            return map;
        }
        map.put(PAGE_TOTAL, MargicNumberConstants.n0);
        map.put(PAGE_ROWS, new ArrayList<>());
        return map;
    }

}
