package com.naivete.framework.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * XmlJsonUtils，xml、json转换工具类
 *
 * @author luoshen
 * @date 2018/9/26 9:34
 */
public class XmlJsonUtils {

    private static Logger logger = LoggerFactory.getLogger(XmlJsonUtils.class);

    private static ObjectMapper mapper = new ObjectMapper();

    /**
     * 将xml格式字符串转换成JSONObject对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:33
     **/
    public static JSONObject convertXml2Json(String xml) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        String result = xmlSerializer.read(xml).toString();
        JSONObject jsonObject = JSONObject.parseObject(result);
        return jsonObject;
    }

    /**
     * 将xml格式数据转成Map对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:34
     **/
    public static Map<String, Object> convertXml2Map(String xml) {
        try {
            XMLSerializer xmlSerializer = new XMLSerializer();
            String json = xmlSerializer.read(xml).toString();
            return mapper.readValue(json, new TypeReference<Map<String, Object>>() {
            });
        } catch (Exception e) {
            logger.error("json解析错误:" + e.getMessage());
        }
        return null;
    }

    /**
     * 将xml数据转成指定类型的对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:33
     **/
    public static <T> T convertXml2Object(String xml, Class<T> valueType) {
        if (StringUtils.isEmpty(xml)) {
            return null;
        }
        XMLSerializer xmlSerializer = new XMLSerializer();
        String json = xmlSerializer.read(xml).toString();
        return JSON.parseObject(json, valueType);
    }

    /**
     * 将json数据转成指定类型的对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:33
     **/
    public static <T> T convertJson2Object(String content, Class<T> valueType) {
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        return JSON.parseObject(content, valueType);
    }

    /**
     * 将对象格式化成json格式数据
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:34
     **/
    public static String convertObject2Json(Object obj) {
        return JSON.toJSONString(obj, true);
    }

    /**
     * 将json格式数据转成Map对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:34
     **/
    public static Map<String, Object> convertJson2Map(String content) {
        try {
            return mapper.readValue(content, new TypeReference<Map<String, Object>>() {
            });
        } catch (Exception e) {
            logger.error("json解析错误:" + e.getMessage());
        }
        return null;
    }

    /**
     * 将Object格式数据转成JSONObject对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:34
     **/
    public static JSONObject converEntityToJSONObject(Object object) {
        try {
            return object == null ? new JSONObject() : JSONObject.parseObject(JSON.toJSONString(object));
        } catch (Exception e) {
            logger.error("json解析错误:" + e.getMessage());
        }
        return null;
    }

    /**
     * 将Object对象转成指定类型的对象
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:33
     **/
    public static <T> T converEntityToObject(Object object, Class<T> objectType) {
        try {
            return object == null ? null : JSON.parseObject(JSON.toJSONString(object), objectType);
        } catch (Exception e) {
            logger.error("json解析错误:" + e.getMessage());
        }
        return null;
    }

}
