/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.common.dao;

import com.naivete.framework.common.constant.MargicNumberConstants;
import java.util.Date;

public class Paginator {
    private int limit = MargicNumberConstants.n20;
    private long start = MargicNumberConstants.n0.intValue();
    private long end = MargicNumberConstants.n20.intValue();
    private long total = MargicNumberConstants.n0.intValue();
    private Date timestamp;
    private long index = MargicNumberConstants.n1.intValue();
    private long pageNum = MargicNumberConstants.n0.intValue();
    private int breakpage = MargicNumberConstants.n5;
    private long currentposition = MargicNumberConstants.n2.intValue();
    private int breakspace = MargicNumberConstants.n2;
    private int maxspace = MargicNumberConstants.n4;
    private long prevnum;
    private long nextnum;

    public Paginator() {
    }

    public Paginator(int index, int limit) {
        if (index < MargicNumberConstants.n0) {
            this.setIndex(MargicNumberConstants.n1.intValue());
        }
        this.setIndex(index);
        this.setLimit(limit);
        this.setStart((this.getIndex() - (long)MargicNumberConstants.n1.intValue()) * (long)this.getLimit());
        this.setEnd(this.getIndex() * (long)this.getLimit());
    }

    public void generateView() {
        this.setPageNum(new Double(Math.ceil(new Double(this.total) / (double)this.getLimit())).intValue());
        if (this.getIndex() > this.getPageNum()) {
            this.setIndex(this.getPageNum());
        }
        this.setPrevnum(this.getIndex() - this.getCurrentposition());
        this.setNextnum(this.getIndex() + this.getCurrentposition());
        if (this.getPrevnum() < (long)MargicNumberConstants.n1.intValue()) {
            this.setPrevnum(MargicNumberConstants.n1.intValue());
        }
        if (this.getNextnum() > this.getPageNum()) {
            this.setNextnum(this.getPageNum());
        }
        this.setEnd(Math.min(this.getIndex() * (long)this.getLimit(), this.getTotal()));
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.setStart((this.getIndex() - (long)MargicNumberConstants.n1.intValue()) * (long)this.getLimit());
        this.setEnd(this.getIndex() * (long)this.getLimit());
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public Long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        if (index < (long)MargicNumberConstants.n1.intValue()) {
            index = MargicNumberConstants.n1.intValue();
        }
        this.index = index;
        this.setStart((this.getIndex() - (long)MargicNumberConstants.n1.intValue()) * (long)this.getLimit());
        this.setEnd(this.getIndex() * (long)this.getLimit());
    }

    public long getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getBreakpage() {
        return this.breakpage;
    }

    public void setBreakpage(int breakpage) {
        this.breakpage = breakpage;
    }

    public long getCurrentposition() {
        return this.currentposition;
    }

    public void setCurrentposition(int currentposition) {
        this.currentposition = currentposition;
    }

    public int getBreakspace() {
        return this.breakspace;
    }

    public void setBreakspace(int breakspace) {
        this.breakspace = breakspace;
    }

    public int getMaxspace() {
        return this.maxspace;
    }

    public void setMaxspace(int maxspace) {
        this.maxspace = maxspace;
    }

    public long getPrevnum() {
        return this.prevnum;
    }

    public void setPrevnum(long prevnum) {
        this.prevnum = prevnum;
    }

    public long getNextnum() {
        return this.nextnum;
    }

    public void setNextnum(long nextnum) {
        this.nextnum = nextnum;
    }

    public boolean isBreakLeft() {
        return this.getPrevnum() - (long)this.getBreakspace() > (long)this.getMaxspace();
    }

    public boolean isBreakRight() {
        return this.getPageNum() - (long)this.getBreakspace() - this.getNextnum() + 1L > (long)this.getMaxspace();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}

