/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.common.dao;

import com.naivete.framework.common.constant.MargicNumberConstants;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class QueryBase {
    private static int DEFAULT_PAGE_SIZE = MargicNumberConstants.n20;
    protected int pageSize = DEFAULT_PAGE_SIZE;
    protected int currentPage = MargicNumberConstants.n1;
    protected long total;
    protected int start = MargicNumberConstants.n0;
    protected int end = MargicNumberConstants.n20;

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        if (pageSize != null && pageSize > MargicNumberConstants.n0) {
            this.pageSize = pageSize;
        }
        this.setStartAndEnd();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        if (currentPage != null && currentPage > MargicNumberConstants.n0) {
            this.currentPage = currentPage;
        }
        this.setStartAndEnd();
    }

    protected void setStartAndEnd() {
        this.start = (this.getCurrentPage() - MargicNumberConstants.n1) * this.getPageSize();
        if (this.start < MargicNumberConstants.n0) {
            this.start = MargicNumberConstants.n0;
        }
        this.end = this.getStart() + this.getPageSize() - MargicNumberConstants.n1;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        if (start != null && start >= MargicNumberConstants.n0) {
            this.start = start;
        }
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        if (end != null && end >= MargicNumberConstants.n0) {
            this.end = end;
        }
    }

    public boolean hasNextPage() {
        return (long)this.getCurrentPage() < this.getTotalPage() - (long)MargicNumberConstants.n1.intValue();
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPage() > MargicNumberConstants.n1;
    }

    public long getTotalPage() {
        if (this.total % (long)this.pageSize == (long)MargicNumberConstants.n0.intValue()) {
            return this.total / (long)this.pageSize;
        }
        return this.total / (long)this.pageSize + (long)MargicNumberConstants.n1.intValue();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

