/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.common.dao;

import com.naivete.framework.common.constant.MargicNumberConstants;
import com.naivete.framework.common.dao.Paginator;
import com.naivete.framework.common.dao.Result;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ResultList<T>
extends Result<T> {
    private static final long serialVersionUID = -8793824978794414238L;
    private static int DEFAULT_PAGE_SIZE = MargicNumberConstants.n20;
    private Collection<T> datalist;
    private long total = MargicNumberConstants.n0.intValue();
    private int pageSize;
    private long start;

    public ResultList() {
        this(MargicNumberConstants.n0.intValue(), MargicNumberConstants.n0.intValue(), DEFAULT_PAGE_SIZE, new ArrayList());
    }

    public ResultList(long start, long totalSize, int pageSize, Collection<T> data) {
        this.pageSize = pageSize;
        this.start = start;
        this.total = totalSize;
        this.datalist = data;
    }

    protected static int getStartOfPage(int pageNo) {
        return ResultList.getStartOfPage(pageNo, DEFAULT_PAGE_SIZE);
    }

    public static int getStartOfPage(int pageNo, int pageSize) {
        return (pageNo - 1) * pageSize;
    }

    public Collection<T> getDatalist() {
        return this.datalist;
    }

    public void setDatalist(Collection<T> data) {
        this.datalist = data;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getTotalPageCount() {
        if (this.total % (long)this.pageSize == (long)MargicNumberConstants.n0.intValue()) {
            return this.total / (long)this.pageSize;
        }
        return this.total / (long)this.pageSize + (long)MargicNumberConstants.n1.intValue();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getCurrentPageNo() {
        return this.start / (long)this.pageSize + (long)MargicNumberConstants.n1.intValue();
    }

    public boolean hasNextPage() {
        return this.getCurrentPageNo() < this.getTotalPageCount() - (long)MargicNumberConstants.n1.intValue();
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPageNo() > (long)MargicNumberConstants.n1.intValue();
    }

    public Paginator getPaginator(Integer currentPage, Integer pageSize) {
        if (null == currentPage) {
            currentPage = MargicNumberConstants.n1;
        }
        if (null == pageSize) {
            pageSize = MargicNumberConstants.n20;
        }
        Paginator paginator = new Paginator(currentPage, pageSize);
        paginator.setTotal(this.total);
        paginator.generateView();
        return paginator;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

