/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.common.lang;

import com.naivete.framework.common.constant.MargicNumberConstants;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MEnum<T extends MEnum>
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3452282956818035040L;
    private static final Map<String, MEnum> EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static Logger logger = LoggerFactory.getLogger(MEnum.class);
    private static Map<Class<MEnum>, Entry> cEnumClasses = new WeakHashMap<Class<MEnum>, Entry>();
    protected transient String iToString = null;
    private String name;
    private String cname;
    private Number value;
    private String desc;

    public static MEnum create() {
        return MEnum.create(null, null, null, null);
    }

    public static MEnum create(String name) {
        return MEnum.create(name, null, null, null);
    }

    public static MEnum create(String name, Number value) {
        return MEnum.create(name, value, null, null);
    }

    public static MEnum create(Number value, String cname) {
        return MEnum.create(null, value, cname, null);
    }

    public static MEnum create(String name, Number value, String cname) {
        return MEnum.create(name, value, cname, null);
    }

    public static MEnum create(String name, Number value, String cname, String desc) {
        MEnum menum = MEnum.init(name);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            menum.name = name;
        }
        menum.cname = cname;
        menum.value = value;
        menum.desc = desc;
        return menum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MEnum init(String name) {
        try {
            Class enumClass = ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)MEnum.getCallerClassName());
            if (enumClass == null) {
                throw new IllegalArgumentException("EnumClass must not be null");
            }
            Class<MEnum> clazz = MEnum.class;
            synchronized (MEnum.class) {
                Entry entry = cEnumClasses.get(enumClass);
                if (entry == null) {
                    entry = MEnum.createEntry(enumClass);
                    WeakHashMap<Class<MEnum>, Entry> myMap = new WeakHashMap<Class<MEnum>, Entry>();
                    myMap.putAll(cEnumClasses);
                    myMap.put(enumClass, entry);
                    cEnumClasses = myMap;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                MEnum enumObject = (MEnum)enumClass.newInstance();
                if (StringUtils.isNotEmpty((CharSequence)name)) {
                    if (!entry.map.containsKey(name)) {
                        enumObject.name = name;
                        entry.map.put(name, enumObject);
                    } else {
                        throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
                    }
                }
                entry.list.add(enumObject);
                return enumObject;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static String getCallerClassName() {
        StackTraceElement[] callers = new Throwable().getStackTrace();
        String enumClass = MEnum.class.getName();
        for (StackTraceElement caller : callers) {
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            if (enumClass.equals(className) || !"<clinit>".equals(methodName)) continue;
            return className;
        }
        throw new IllegalArgumentException("");
    }

    private static <T> Entry getEntry(Class<T> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!MEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = cEnumClasses.get(enumClass);
        if (entry == null) {
            try {
                Class.forName(enumClass.getName(), true, enumClass.getClassLoader());
                entry = cEnumClasses.get(enumClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entry;
    }

    private static Entry createEntry(Class enumClass) {
        Entry entry = new Entry();
        for (Class cls = enumClass.getSuperclass(); cls != null && cls != MEnum.class; cls = cls.getSuperclass()) {
            Entry loopEntry = cEnumClasses.get(cls);
            if (loopEntry == null) continue;
            entry.list.addAll(loopEntry.list);
            entry.map.putAll(loopEntry.map);
            break;
        }
        return entry;
    }

    public static <T> MEnum getEnum(Class<T> enumClass, String name) {
        Entry entry = MEnum.getEntry(enumClass);
        if (entry == null) {
            return null;
        }
        return entry.map.get(name);
    }

    public static <T> MEnum getEnum(Class<T> enumClass, Number value) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = MEnum.getEnumList(enumClass);
        for (MEnum enumeration : list) {
            if (enumeration.value() != value.intValue()) continue;
            return enumeration;
        }
        return null;
    }

    public static <T> MEnum getEnumByCnName(Class<T> enumClass, String cnName) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = MEnum.getEnumList(enumClass);
        for (MEnum enumeration : list) {
            if (!enumeration.cname.equalsIgnoreCase(cnName)) continue;
            return enumeration;
        }
        return null;
    }

    public static <T> Map<String, MEnum> getEnumMap(Class<T> enumClass) {
        Entry entry = MEnum.getEntry(enumClass);
        if (entry == null) {
            return EMPTY_MAP;
        }
        return entry.unmodifiableMap;
    }

    public static <T> List getEnumList(Class<T> enumClass) {
        Entry entry = MEnum.getEntry(enumClass);
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return entry.unmodifiableList;
    }

    protected static Iterator<MEnum> iterator(Class<MEnum> enumClass) {
        return MEnum.getEnumList(enumClass).iterator();
    }

    protected Object readResolve() {
        Entry entry = cEnumClasses.get(this.getEnumClass());
        if (entry == null) {
            return null;
        }
        return entry.map.get(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class getEnumClass() {
        Class<?> enumClass;
        Class<?> clazz = enumClass = this.getClass();
        synchronized (clazz) {
            return enumClass;
        }
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.name.equals(((MEnum)other).name);
        }
        return other.getClass().getName().equals(this.getClass().getName());
    }

    public int compareTo(Object other) {
        if (other.equals(this)) {
            return 0;
        }
        if (other.getClass() != this.getClass()) {
            throw new ClassCastException("Different enum class '" + ClassUtils.getShortClassName(other.getClass()) + "'");
        }
        return this.name.compareTo(((MEnum)other).name);
    }

    public boolean isIn(Class<T> enumClass, int value) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        List list = MEnum.getEnumList(enumClass);
        for (MEnum enumeration : list) {
            if (enumeration.getValue().intValue() != value) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.iToString == null) {
            String shortName = ClassUtils.getShortClassName((Class)this.getEnumClass());
            this.iToString = shortName + "[" + this.name() + "]";
        }
        return this.iToString;
    }

    public final int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    public final int value() {
        return this.value.intValue();
    }

    public final byte byteValue() {
        return this.value.byteValue();
    }

    public final short shortValue() {
        return this.value.shortValue();
    }

    public final long longValue() {
        return this.value.longValue();
    }

    public final String name() {
        if (this.name == null) {
            Class enumClass = this.getEnumClass();
            Entry entry = cEnumClasses.get(this.getEnumClass());
            entry.populateNames(enumClass);
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Number getValue() {
        return this.value;
    }

    public String getCname() {
        return this.cname;
    }

    public String getDesc() {
        return this.desc;
    }

    private static class Entry {
        final Map<String, MEnum> map = new HashMap<String, MEnum>();
        final Map<String, MEnum> unmodifiableMap = Collections.unmodifiableMap(this.map);
        final List<MEnum> list = new ArrayList<MEnum>(MargicNumberConstants.n25);
        final List<MEnum> unmodifiableList = Collections.unmodifiableList(this.list);

        protected Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateNames(Class enumClass) {
            Class clazz = enumClass;
            synchronized (clazz) {
                Field[] fields;
                block5: for (Field field : fields = enumClass.getFields()) {
                    int modifier = field.getModifiers();
                    if (!Modifier.isPublic(modifier) || !Modifier.isFinal(modifier) || !Modifier.isStatic(modifier)) continue;
                    try {
                        Object value = field.get(null);
                        String fname = field.getName();
                        for (MEnum enumObject : this.unmodifiableList) {
                            if (value == null || !value.equals(enumObject) || enumObject.name != null || this.unmodifiableMap.containsKey(fname)) continue;
                            enumObject.name = fname;
                            this.map.put(fname, enumObject);
                            continue block5;
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
        }
    }
}

