/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlJsonUtils {
    private static Logger logger = LoggerFactory.getLogger(XmlJsonUtils.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static JSONObject convertXml2Json(String xml) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        String result = xmlSerializer.read(xml).toString();
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        return jsonObject;
    }

    public static Map<String, Object> convertXml2Map(String xml) {
        try {
            XMLSerializer xmlSerializer = new XMLSerializer();
            String json = xmlSerializer.read(xml).toString();
            return (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            logger.error("json\u89e3\u6790\u9519\u8bef:" + e.getMessage());
            return null;
        }
    }

    public static <T> T convertXml2Object(String xml, Class<T> valueType) {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        XMLSerializer xmlSerializer = new XMLSerializer();
        String json = xmlSerializer.read(xml).toString();
        return (T)JSON.parseObject((String)json, valueType);
    }

    public static <T> T convertJson2Object(String content, Class<T> valueType) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        return (T)JSON.parseObject((String)content, valueType);
    }

    public static String convertObject2Json(Object obj) {
        return JSON.toJSONString((Object)obj, (boolean)true);
    }

    public static Map<String, Object> convertJson2Map(String content) {
        try {
            return (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            logger.error("json\u89e3\u6790\u9519\u8bef:" + e.getMessage());
            return null;
        }
    }

    public static JSONObject converEntityToJSONObject(Object object) {
        try {
            return object == null ? new JSONObject() : JSONObject.parseObject((String)JSON.toJSONString((Object)object));
        }
        catch (Exception e) {
            logger.error("json\u89e3\u6790\u9519\u8bef:" + e.getMessage());
            return null;
        }
    }

    public static <T> T converEntityToObject(Object object, Class<T> objectType) {
        try {
            return (T)(object == null ? null : JSON.parseObject((String)JSON.toJSONString((Object)object), objectType));
        }
        catch (Exception e) {
            logger.error("json\u89e3\u6790\u9519\u8bef:" + e.getMessage());
            return null;
        }
    }
}

