package com.naivete.framework.schedule.console.config;

import com.naivete.framework.schedule.console.config.annotation.EnableScheduleConsoleConfiguration;
import com.naivete.framework.schedule.console.manager.ConsoleManager;
import com.naivete.framework.schedule.core.strategy.TBScheduleManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;

/**
 * ScheduleConsoleConfiguration
 *
 * @author luoshen
 * @date 2018/9/21 13:30
 */
@Configuration
@EnableConfigurationProperties(ScheduleConsoleProperteis.class)
@ConditionalOnBean(annotation = EnableScheduleConsoleConfiguration.class)
@ComponentScan("com.naivete.framework.schedule.console.controller")
public class ScheduleConsoleConfiguration {

    // 打印日志
    private static Logger logger = LoggerFactory.getLogger(ScheduleConsoleConfiguration.class);
    // zk配置保存地址
    @Resource
    private ScheduleConsoleProperteis properteis;

    @Bean(name = "consoleManager")
    public ConsoleManager consoleManager(TBScheduleManagerFactory consoleScheduleManagerFactory) {
        ConsoleManager consoleManager = new ConsoleManager();
        consoleManager.setConfigFile(properteis.getConfigFile());
        consoleManager.setScheduleManagerFactory(consoleScheduleManagerFactory);
        return consoleManager;
    }

    @Bean(name = "consoleScheduleManagerFactory")
    public TBScheduleManagerFactory consoleScheduleManagerFactory() {
        TBScheduleManagerFactory scheduleManagerFactory = new TBScheduleManagerFactory();
        // Console不启动调度能力
        scheduleManagerFactory.start = false;
        try {
            File file = new File(properteis.getConfigFile());
            if (file.exists() == true) {
                Properties p = new Properties();
                FileReader reader = new FileReader(file);
                p.load(reader);
                reader.close();
                scheduleManagerFactory.init(p);
                logger.info("加载Schedule配置文件：" + properteis.getConfigFile());
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("初始化scheduleManagerFactory异常:" + e);
        }
        return scheduleManagerFactory;
    }

}
