package com.naivete.framework.schedule.console.controller;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.util.PageUtils;
import com.naivete.framework.schedule.console.manager.ConsoleManager;
import com.naivete.framework.schedule.core.strategy.ManagerFactoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * ManagerFactoryController
 *
 * @author luoshen
 * @date 2018/9/19 18:17
 */
@Controller
@RequestMapping("/schedule/console/managerFactory")
public class ManagerFactoryController {

    // 打印日志
    private static Logger logger = LoggerFactory.getLogger(ManagerFactoryController.class);

    // 控制台管理
    @Resource
    private ConsoleManager consoleManager;

    /**
     * 获取机器管理列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/managerFactoryList")
    public @ResponseBody
    Object managerFactoryList() {
        try {
            List<ManagerFactoryInfo> list = consoleManager.getScheduleStrategyManager().loadAllManagerFactoryInfo();
            return PageUtils.resultJSON(list);
        } catch (Exception e) {
            logger.error("获取机器管理列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 停止或恢复机器
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/pauseOrResumeManagerFactory")
    public @ResponseBody
    Object pauseOrResumeManagerFactory(String uuid) {
        Result<Void> result = new Result<>();
        try {
            ManagerFactoryInfo managerFactory = consoleManager.getScheduleStrategyManager().loadManagerFactoryInfo(uuid);
            consoleManager.getScheduleStrategyManager().updateManagerFactoryInfo(uuid, !managerFactory.isStart());
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("停止或恢复机器异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

}
