package com.naivete.framework.schedule.console.controller;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.util.PageUtils;
import com.naivete.framework.schedule.console.constants.StrategyStatusConstants;
import com.naivete.framework.schedule.console.manager.ConsoleManager;
import com.naivete.framework.schedule.core.strategy.ScheduleStrategy;
import com.naivete.framework.schedule.core.strategy.ScheduleStrategyRunntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * StrategyController
 *
 * @author luoshen
 * @date 2018/9/19 18:17
 */
@Controller
@RequestMapping("/schedule/console/strategyManager")
public class StrategyManagerController {

    // 打印日志
    private static Logger logger = LoggerFactory.getLogger(StrategyManagerController.class);

    // 控制台管理
    @Resource
    private ConsoleManager consoleManager;

    /**
     * 获取策略列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/strategyList")
    public @ResponseBody
    Object strategyList() {
        try {
            List<ScheduleStrategy> strategyList = consoleManager.getScheduleStrategyManager().loadAllScheduleStrategy();
            return PageUtils.resultJSON(strategyList);
        } catch (Exception e) {
            logger.error("获取任务列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 获取策略列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/strategyListByUUID")
    public @ResponseBody
    Object strategyListByUUID(String uuid) {
        try {
            List<ScheduleStrategyRunntime> runntimeList = consoleManager.getScheduleStrategyManager().loadAllScheduleStrategyRunntimeByUUID(uuid);
            return PageUtils.resultJSON(runntimeList);
        } catch (Exception e) {
            logger.error("获取任务列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 根据策略名称获取运行策略列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/strategyRuntimeList")
    public @ResponseBody
    Object strategyRuntimeList(String strategyName) {
        try {
            List<ScheduleStrategyRunntime> runntimeList = consoleManager.getScheduleStrategyManager().loadAllScheduleStrategyRunntimeByTaskType(strategyName);
            return PageUtils.resultJSON(runntimeList);
        } catch (Exception e) {
            logger.error("根据策略名称获取运行策略列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 保存策略
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/saveStrategy")
    public @ResponseBody
    Object saveStrategy(ScheduleStrategy strategy, String strategyFlag, String ips) {
        Result<Void> result = new Result<>();
        try {
            strategy.setIPList(ips.split(","));
            if (strategyFlag.equalsIgnoreCase("addStrategy")) {
                consoleManager.getScheduleStrategyManager().createScheduleStrategy(strategy);
            } else if (strategyFlag.equalsIgnoreCase("editStrategy")) {
                consoleManager.getScheduleStrategyManager().updateScheduleStrategy(strategy);
            }
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存策略异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 删除策略
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/removeStrategy")
    public @ResponseBody
    Object removeStrategy(String strategyName) {
        Result<Void> result = new Result<>();
        try {
            consoleManager.getScheduleStrategyManager().deleteMachineStrategy(strategyName);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("删除策略异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 停止或恢复策略
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/pauseOrResumeStrategy")
    public @ResponseBody
    Object pauseOrResumeStrategy(String strategyName) {
        Result<Void> result = new Result<>();
        try {
            ScheduleStrategy strategy = consoleManager.getScheduleStrategyManager().loadStrategy(strategyName);
            if (strategy.getSts().equals(StrategyStatusConstants.PAUSE.name())) {
                consoleManager.getScheduleStrategyManager().resume(strategyName);
            } else if (strategy.getSts().equals(StrategyStatusConstants.RESUME.name())) {
                consoleManager.getScheduleStrategyManager().pause(strategyName);
            }
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("停止或恢复策略异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 根据名称查询策略
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/getByStrategyName")
    public @ResponseBody
    Object getByStrategyName(String strategyName) {
        Result<ScheduleStrategy> result = new Result<>();
        try {
            ScheduleStrategy strategy = consoleManager.getScheduleStrategyManager().loadStrategy(strategyName);
            result.setData(strategy);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("根据名称查询策略异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

}
