package com.naivete.framework.schedule.console.controller;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.util.PageUtils;
import com.naivete.framework.schedule.console.manager.ConsoleManager;
import com.naivete.framework.schedule.core.taskmanager.ScheduleServer;
import com.naivete.framework.schedule.core.taskmanager.ScheduleTaskItem;
import com.naivete.framework.schedule.core.taskmanager.ScheduleTaskType;
import com.naivete.framework.schedule.core.taskmanager.ScheduleTaskTypeRunningInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * TaskManagerController
 *
 * @author luoshen
 * @date 2018/9/19 18:17
 */
@Controller
@RequestMapping("/schedule/console/taskManager")
public class TaskManagerController {

    // 打印日志
    private static Logger logger = LoggerFactory.getLogger(TaskManagerController.class);

    // 控制台管理
    @Resource
    private ConsoleManager consoleManager;

    /**
     * 获取任务列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/taskList")
    public @ResponseBody
    Object taskList() {
        try {
            List<ScheduleTaskType> taskTypes = consoleManager.getScheduleDataManager().getAllTaskTypeBaseInfo();
            return PageUtils.resultJSON(taskTypes);
        } catch (Exception e) {
            logger.error("获取任务列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 获取任务列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/taskListByUUID")
    public @ResponseBody
    Object taskListByUUID(String uuid) {
        try {
            List<ScheduleServer> serverList = consoleManager.getScheduleDataManager().selectScheduleServerByManagerFactoryUUID(uuid);
            return PageUtils.resultJSON(serverList);
        } catch (Exception e) {
            logger.error("获取任务列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 根据任务类型获取运行任务列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/taskRuntimeList")
    public @ResponseBody
    Object taskRuntimeList(String baseTaskType) {
        try {
            List<ScheduleTaskTypeRunningInfo> taskTypeRunningInfoList = consoleManager.getScheduleDataManager().getAllTaskTypeRunningInfo(baseTaskType);
            for (ScheduleTaskTypeRunningInfo taskTypeRunningInfo : taskTypeRunningInfoList) {
                List<ScheduleServer> serverList = consoleManager.getScheduleDataManager().selectAllValidScheduleServer(taskTypeRunningInfo.getTaskType());
                return PageUtils.resultJSON(serverList);
            }
        } catch (Exception e) {
            logger.error("根据任务类型获取运行任务列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 获取任务项列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/taskItemList")
    public @ResponseBody
    Object taskItemList(String taskType) {
        try {
            List<ScheduleTaskItem> taskItemList = consoleManager.getScheduleDataManager().loadAllTaskItem(taskType);
            return PageUtils.resultJSON(taskItemList);
        } catch (Exception e) {
            logger.error("获取任务项列表异常：" + e);
        }
        return PageUtils.resultJSON(new ArrayList());
    }

    /**
     * 根据名称查询任务
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/getByTaskType")
    public @ResponseBody
    Object getByTaskType(String taskType) {
        Result<ScheduleTaskType> result = new Result<>();
        try {
            ScheduleTaskType task = consoleManager.getScheduleDataManager().loadTaskTypeBaseInfo(taskType);
            result.setData(task);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("根据名称查询任务异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 保存任务
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/saveTask")
    public @ResponseBody
    Object saveTask(ScheduleTaskType taskType, String taskFlag) {
        Result<Void> result = new Result<>();
        try {
            if (taskFlag.equalsIgnoreCase("addTask")) {
                consoleManager.getScheduleDataManager().createBaseTaskType(taskType);
            } else if (taskFlag.equalsIgnoreCase("editTask")) {
                consoleManager.getScheduleDataManager().updateBaseTaskType(taskType);
            }
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存任务异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 删除任务
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/removeTask")
    public @ResponseBody
    Object removeTask(String taskType) {
        Result<Void> result = new Result<>();
        try {
            consoleManager.getScheduleDataManager().deleteTaskType(taskType);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("删除任务异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 清理任务
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/clearTask")
    public @ResponseBody
    Object clearTask(String taskType) {
        Result<Void> result = new Result<>();
        try {
            consoleManager.getScheduleDataManager().clearTaskType(taskType);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("清理任务异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

}
