package com.naivete.framework.schedule.console.controller;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.schedule.console.manager.ConsoleManager;
import com.naivete.framework.schedule.console.model.ZKConfig;
import com.naivete.framework.schedule.core.zk.ZKManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.Properties;

/**
 * ZKManagerController
 *
 * @author luoshen
 * @date 2018/9/19 18:17
 */
@Controller
@RequestMapping("/schedule/console/zkManager")
public class ZKManagerController {

    // 打印日志
    private static Logger logger = LoggerFactory.getLogger(ZKManagerController.class);

    // 控制台管理
    @Resource
    private ConsoleManager consoleManager;

    /**
     * 获取zk配置
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/loadConfig")
    public @ResponseBody
    Object loadConfig() {
        Result<ZKConfig> result = new Result<>();
        try {
            ZKConfig zkConfig = new ZKConfig();
            Properties p = consoleManager.loadConfig();
            zkConfig.setZkConnectString(p.getProperty(ZKManager.keys.zkConnectString.toString()));
            zkConfig.setZkSessionTimeout(p.getProperty(ZKManager.keys.zkSessionTimeout.toString()));
            zkConfig.setRootPath(p.getProperty(ZKManager.keys.rootPath.toString()));
            zkConfig.setUserName(p.getProperty(ZKManager.keys.userName.toString()));
            zkConfig.setPassword(p.getProperty(ZKManager.keys.password.toString()));
            result.setData(zkConfig);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("获取zk配置异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 保存zk配置
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    @RequestMapping("/save")
    public @ResponseBody
    Object save(ZKConfig zkConfig) {
        Result<Void> result = new Result<>();
        try {
            Properties p = new Properties();
            p.setProperty(ZKManager.keys.zkConnectString.toString(), zkConfig.getZkConnectString());
            p.setProperty(ZKManager.keys.rootPath.toString(), zkConfig.getRootPath());
            p.setProperty(ZKManager.keys.userName.toString(), zkConfig.getUserName());
            p.setProperty(ZKManager.keys.password.toString(), zkConfig.getPassword());
            p.setProperty(ZKManager.keys.zkSessionTimeout.toString(), zkConfig.getZkSessionTimeout());
            consoleManager.saveConfigInfo(p);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存zk配置异常：" + e);
            logger.error(result.getErrorMessage());
        }
        try {
            consoleManager.getScheduleManagerFactory().initialData();
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("刷新配置异常：" + e);
            logger.error(result.getErrorMessage());
        }
        return result;
    }

}
