package com.naivete.framework.schedule.console.manager;


import com.naivete.framework.schedule.core.strategy.TBScheduleManagerFactory;
import com.naivete.framework.schedule.core.taskmanager.IScheduleDataManager;
import com.naivete.framework.schedule.core.zk.ScheduleStrategyDataManager4ZK;
import com.naivete.framework.schedule.core.zk.ZKManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

/**
 * ConsoleManager
 *
 * @author luoshen
 * @date 2018/9/21 13:51
 */
public class ConsoleManager {

    private static Logger logger = LoggerFactory.getLogger(ConsoleManager.class);

    private String configFile;

    // 管理工具
    private TBScheduleManagerFactory scheduleManagerFactory;

    /**
     * 是否已初始化
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public boolean isInitial() {
        return this.scheduleManagerFactory != null;
    }

    /**
     * 初始化
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public boolean initial() throws Exception {
        if (scheduleManagerFactory != null) {
            return true;
        }
        File file = new File(this.configFile);
        scheduleManagerFactory = new TBScheduleManagerFactory();
        scheduleManagerFactory.start = false;
        if (file.exists() == true) {
            // Console不启动调度能力
            Properties p = new Properties();
            FileReader reader = new FileReader(file);
            p.load(reader);
            reader.close();
            scheduleManagerFactory.init(p);
            logger.info("加载Schedule配置文件：" + configFile);
            return true;
        } else {
            return false;
        }
    }

    /**
     * getScheduleManagerFactory
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public TBScheduleManagerFactory getScheduleManagerFactory() throws Exception {
        if (isInitial() == false) {
            initial();
        }
        return scheduleManagerFactory;
    }

    public void setScheduleManagerFactory(TBScheduleManagerFactory scheduleManagerFactory) {
        this.scheduleManagerFactory = scheduleManagerFactory;
    }

    /**
     * getScheduleDataManager
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public IScheduleDataManager getScheduleDataManager() throws Exception {
        if (isInitial() == false) {
            initial();
        }
        return scheduleManagerFactory.getScheduleDataManager();
    }

    /**
     * getScheduleStrategyManager
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public ScheduleStrategyDataManager4ZK getScheduleStrategyManager() throws Exception {
        if (isInitial() == false) {
            initial();
        }
        return scheduleManagerFactory.getScheduleStrategyManager();
    }

    /**
     * loadConfig
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public Properties loadConfig() throws IOException {
        File file = new File(configFile);
        Properties properties;
        if (file.exists() == false) {
            properties = ZKManager.createProperties();
        } else {
            properties = new Properties();
            FileReader reader = new FileReader(file);
            properties.load(reader);
            reader.close();
        }
        return properties;
    }

    /**
     * saveConfigInfo
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    public void saveConfigInfo(Properties p) throws Exception {
        try {
            FileWriter writer = new FileWriter(configFile);
            p.store(writer, "");
            writer.close();
        } catch (Exception ex) {
            throw new Exception("不能写入配置信息到文件：" + configFile, ex);
        }
        if (scheduleManagerFactory == null) {
            initial();
        } else {
            scheduleManagerFactory.reInit(p);
        }
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}
