/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.manager;

import com.naivete.framework.schedule.client.manager.TaskActionManager;
import com.naivete.framework.schedule.client.service.CommonTaskAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TaskActionManagerFactory
implements FactoryBean<TaskActionManager>,
InitializingBean,
ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(TaskActionManagerFactory.class);
    private ApplicationContext context;
    private TaskActionManager commonTaskActionManager;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.commonTaskActionManager = new TaskActionManager();
        String[] actionNames = this.context.getBeanNamesForType(CommonTaskAction.class, true, false);
        HashMap<String, List<CommonTaskAction>> actionMap = new HashMap<String, List<CommonTaskAction>>();
        if (actionNames != null && actionNames.length > 0) {
            for (int i = 0; i < actionNames.length; ++i) {
                String actionName = actionNames[i];
                CommonTaskAction action = (CommonTaskAction)this.context.getBean(actionName, CommonTaskAction.class);
                ArrayList<CommonTaskAction> taskActionList = (ArrayList<CommonTaskAction>)actionMap.get(action.getActionType());
                if (taskActionList == null) {
                    taskActionList = new ArrayList<CommonTaskAction>();
                    actionMap.put(action.getActionType(), taskActionList);
                }
                taskActionList.add(action);
            }
        } else {
            this.logger.warn("No TaskAction is defined in the spring container");
        }
        this.commonTaskActionManager.setActions(actionMap);
    }

    public boolean isSingleton() {
        return true;
    }

    public TaskActionManager getObject() throws Exception {
        return this.commonTaskActionManager;
    }

    public Class<?> getObjectType() {
        return TaskActionManager.class;
    }
}

