/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.model;

import com.naivete.framework.schedule.client.dao.ScheduleItemDAO;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.manager.TaskActionManager;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.model.ScheduleQuery;
import com.naivete.framework.schedule.client.util.ScheduleDayWeek;
import com.naivete.framework.schedule.client.util.ScheduleTable;
import com.naivete.framework.schedule.core.TaskItemDefine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.support.TransactionTemplate;

public class BaseAsyncScheduleTask
implements Serializable {
    private static final long serialVersionUID = -3802957624000294819L;
    protected ScheduleItemDAO commonScheduleItemDAO;
    protected TaskActionManager commonTaskActionManager;
    protected TransactionTemplate transactionTemplateSchedule;
    protected String taskType;
    private Map<String, String> taskTypeMap;

    private ScheduleQuery assembleScheduleQuery(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        ScheduleQuery query = new ScheduleQuery();
        query.setNextRetryTime(System.currentTimeMillis());
        Integer[] taskList = new Integer[taskItemList.size()];
        int i = 0;
        for (TaskItemDefine taskDefine : taskItemList) {
            taskList[i] = Integer.valueOf(taskDefine.getTaskItemId());
            ++i;
        }
        query.setOwnSign(OwnSignManager.ownSign);
        query.setData(taskList);
        query.setPageSize(eachFetchDataNum);
        query.setOrderBy("next_retry_time");
        query.setTaskItemNum(taskItemNum);
        query.setTaskType(this.getTaskType());
        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
        int ampm = ScheduleDayWeek.getAmPm();
        query.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
        return query;
    }

    protected List<ScheduleItem> selectScheduleItems(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        ScheduleQuery query = this.assembleScheduleQuery(taskParameter, ownSign, taskItemNum, taskItemList, eachFetchDataNum);
        List<ScheduleItem> result = this.commonScheduleItemDAO.selectList(query);
        return result;
    }

    protected List<List<ScheduleItem>> selectScheduleItemsForSerial(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        ScheduleQuery query = this.assembleScheduleQuery(taskParameter, ownSign, taskItemNum, taskItemList, eachFetchDataNum);
        List<ScheduleItem> resultTemp = this.commonScheduleItemDAO.selectListForSerial(query);
        if (resultTemp == null || resultTemp.size() == 0) {
            return null;
        }
        HashMap<String, ArrayList<ScheduleItem>> result = new HashMap<String, ArrayList<ScheduleItem>>();
        for (ScheduleItem scheduleItem : resultTemp) {
            String bizId = scheduleItem.getBizId();
            ArrayList<ScheduleItem> scheduleItems = (ArrayList<ScheduleItem>)result.get(bizId);
            if (scheduleItems == null) {
                scheduleItems = new ArrayList<ScheduleItem>();
                result.put(bizId, scheduleItems);
            }
            scheduleItems.add(scheduleItem);
        }
        return new ArrayList<List<ScheduleItem>>(result.values());
    }

    public ScheduleItemDAO getCommonScheduleItemDAO() {
        return this.commonScheduleItemDAO;
    }

    public void setCommonScheduleItemDAO(ScheduleItemDAO commonScheduleItemDAO) {
        this.commonScheduleItemDAO = commonScheduleItemDAO;
    }

    public TaskActionManager getCommonTaskActionManager() {
        return this.commonTaskActionManager;
    }

    public void setCommonTaskActionManager(TaskActionManager commonTaskActionManager) {
        this.commonTaskActionManager = commonTaskActionManager;
    }

    public TransactionTemplate getTransactionTemplateSchedule() {
        return this.transactionTemplateSchedule;
    }

    public void setTransactionTemplateSchedule(TransactionTemplate transactionTemplateSchedule) {
        this.transactionTemplateSchedule = transactionTemplateSchedule;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Map<String, String> getTaskTypeMap() {
        return this.taskTypeMap;
    }

    public void setTaskTypeMap(Map<String, String> taskTypeMap) {
        this.taskTypeMap = taskTypeMap;
    }
}

