/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.service.impl;

import com.naivete.framework.schedule.client.constant.ScheduleBizStatusConst;
import com.naivete.framework.schedule.client.constant.ScheduleStatusConst;
import com.naivete.framework.schedule.client.dao.ScheduleItemDAO;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.service.ScheduleService;
import com.naivete.framework.schedule.client.util.ScheduleDayWeek;
import com.naivete.framework.schedule.client.util.ScheduleTable;
import java.sql.Timestamp;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static Logger logger = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Resource
    private ScheduleItemDAO commonScheduleItemDAO;

    @Override
    public void addScheduleTask(ScheduleItem scheduleItem) {
        ScheduleItem task = new ScheduleItem();
        task.setBizId(scheduleItem.getBizId());
        task.setBizStatus(ScheduleBizStatusConst.DEFAULT.value());
        if (scheduleItem.getNextRetryTime() == null) {
            task.setNextRetryTime(System.currentTimeMillis());
        } else {
            task.setNextRetryTime(scheduleItem.getNextRetryTime());
        }
        if (null != scheduleItem.getId()) {
            task.setId(scheduleItem.getId());
        }
        if (null != scheduleItem.getIsCycle()) {
            task.setIsCycle(scheduleItem.getIsCycle());
        }
        task.setErrorLog(scheduleItem.getErrorLog());
        task.setParam(scheduleItem.getParam());
        task.setApplication(scheduleItem.getApplication());
        task.setRemark(scheduleItem.getRemark());
        task.setRetryNums(0);
        task.setStatus(ScheduleStatusConst.EXECUTE.byteValue());
        task.setTaskType(scheduleItem.getTaskType());
        task.setCreateDate(new Timestamp(System.currentTimeMillis()));
        task.setOwnSign(OwnSignManager.ownSign);
        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
        int ampm = ScheduleDayWeek.getAmPm();
        task.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
        logger.info("tableNum:" + ScheduleTable.getNum(dayWeek, ampm) + " | dayWeek: " + dayWeek + " | ampm: " + ampm);
        this.commonScheduleItemDAO.insert(task);
    }
}

