/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.task;

import com.naivete.framework.schedule.client.config.annotation.Task;
import com.naivete.framework.schedule.client.dao.ScheduleItemTruncateDAO;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.util.ScheduleDayWeek;
import com.naivete.framework.schedule.client.util.ScheduleTable;
import com.naivete.framework.schedule.core.IScheduleTaskDealSingle;
import com.naivete.framework.schedule.core.TaskItemDefine;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Task
public class DeleteTransferScheduleTask
implements IScheduleTaskDealSingle<ScheduleItem> {
    private static Logger logger = LoggerFactory.getLogger(DeleteTransferScheduleTask.class);
    @Resource
    private ScheduleItemTruncateDAO commonScheduleItemTruncateDAO;

    private static String frontCompWithZore(int sourceDate, int formatLength) {
        String newString = String.format("%0" + formatLength + "d", sourceDate);
        return newString;
    }

    public List<ScheduleItem> selectTasks(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
        int ampm = ScheduleDayWeek.getAmPm();
        String nowTableNum = ScheduleTable.getNum(dayWeek, ampm);
        this.deleteScheduleData(Integer.valueOf(nowTableNum), 1);
        this.deleteScheduleData(Integer.valueOf(nowTableNum), 2);
        return null;
    }

    private void deleteScheduleData(int nowTableNum, int offset) {
        int deleteTableNum = (nowTableNum + offset) % 14;
        String tableNum = DeleteTransferScheduleTask.frontCompWithZore(deleteTableNum, 2);
        try {
            this.commonScheduleItemTruncateDAO.dropBySeparate(tableNum);
        }
        catch (Exception e) {
            this.commonScheduleItemTruncateDAO.dropBySeparate(tableNum);
        }
        try {
            this.commonScheduleItemTruncateDAO.createBySeparate(tableNum);
        }
        catch (Exception e) {
            this.commonScheduleItemTruncateDAO.createBySeparate(tableNum);
        }
        logger.info("DeleteTransferScheduleTask\u5f85\u8fc1\u79fb\u6570\u636e\u8868\u6e05\u7a7a\u5df2\u7ecf\u5b8c\u6210\uff01");
    }

    public Comparator<ScheduleItem> getComparator() {
        return null;
    }

    public boolean execute(ScheduleItem task, String ownSign) {
        return true;
    }
}

