/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.config;

import com.naivete.framework.schedule.client.config.ScheduleProperteis;
import com.naivete.framework.schedule.client.config.annotation.AsyncTask;
import com.naivete.framework.schedule.client.config.annotation.EnableScheduleConfiguration;
import com.naivete.framework.schedule.client.dao.ScheduleItemDAO;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.manager.TaskActionManager;
import com.naivete.framework.schedule.client.manager.TaskActionManagerFactory;
import com.naivete.framework.schedule.core.strategy.TBScheduleManagerFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.mybatis.spring.annotation.MapperScan;
import org.reflections.Reflections;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@EnableConfigurationProperties(value={ScheduleProperteis.class})
@ConditionalOnBean(annotation={EnableScheduleConfiguration.class})
@MapperScan(value={"com.naivete.framework.schedule.client.dao"})
@ComponentScan(value={"com.naivete.framework.schedule.client.service", "com.naivete.framework.schedule.client.task"})
public class ScheduleConfiguration
implements ApplicationContextAware {
    protected ConfigurableApplicationContext applicationContext;
    @Autowired
    private ScheduleProperteis properteis;
    @Resource
    private ScheduleItemDAO commonScheduleItemDAO;
    @Resource
    private TaskActionManager commonTaskActionManager;
    @Resource
    private TransactionTemplate transactionTemplateSchedule;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @PostConstruct
    public void init() {
        Reflections reflections = new Reflections(new Object[0]);
        Set annotated = reflections.getTypesAnnotatedWith(AsyncTask.class);
        for (Class serviceClass : annotated) {
            for (Annotation annotation : serviceClass.getAnnotations()) {
                if (!(annotation instanceof AsyncTask)) continue;
                RootBeanDefinition beanDefinition = new RootBeanDefinition();
                String taskName = (String)AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get("taskName");
                String taskType = (String)AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get("taskType");
                Class beanType = (Class)AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get("beanType");
                beanDefinition.setBeanClass(beanType);
                beanDefinition.getPropertyValues().addPropertyValue("taskType", (Object)taskType);
                beanDefinition.getPropertyValues().addPropertyValue("commonScheduleItemDAO", (Object)this.commonScheduleItemDAO);
                beanDefinition.getPropertyValues().addPropertyValue("commonTaskActionManager", (Object)this.commonTaskActionManager);
                beanDefinition.getPropertyValues().addPropertyValue("transactionTemplateSchedule", (Object)this.transactionTemplateSchedule);
                beanDefinition.setLazyInit(true);
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
                registry.registerBeanDefinition(taskName, (BeanDefinition)beanDefinition);
            }
        }
    }

    @Bean(initMethod="init")
    public TBScheduleManagerFactory tbScheduleManagerFactory() {
        TBScheduleManagerFactory tbScheduleManagerFactory = new TBScheduleManagerFactory();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zkConnectString", this.properteis.getZkConnectString());
        map.put("rootPath", this.properteis.getRootPath());
        map.put("zkSessionTimeout", this.properteis.getZkSessionTimeout());
        map.put("userName", this.properteis.getUserName());
        map.put("password", this.properteis.getPassword());
        map.put("isCheckParentPath", this.properteis.getIsCheckParentPath());
        tbScheduleManagerFactory.setZkConfig(map);
        return tbScheduleManagerFactory;
    }

    @Bean
    public OwnSignManager ownSignManager() {
        OwnSignManager ownSignManager = new OwnSignManager();
        ownSignManager.setOwnSign(this.properteis.getOwnSign());
        return ownSignManager;
    }

    @Bean
    public TaskActionManagerFactory taskActionManagerFactory() {
        return new TaskActionManagerFactory();
    }
}

