/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.service.impl;

import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import com.naivete.framework.schedule.client.constant.ScheduleBizStatusConst;
import com.naivete.framework.schedule.client.constant.ScheduleStatusConst;
import com.naivete.framework.schedule.client.dao.ScheduleItemDAO;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.model.ScheduleQuery;
import com.naivete.framework.schedule.client.service.ScheduleService;
import com.naivete.framework.schedule.client.util.ScheduleDayWeek;
import com.naivete.framework.schedule.client.util.ScheduleTable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static Logger logger = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Resource
    private ScheduleItemDAO commonScheduleItemDAO;
    @Resource
    private TransactionTemplate transactionTemplateSchedule;

    @Override
    public void addScheduleTask(ScheduleItem scheduleItem) {
        ScheduleItem task = new ScheduleItem();
        task.setBizId(scheduleItem.getBizId());
        task.setBizStatus(ScheduleBizStatusConst.DEFAULT.value());
        if (scheduleItem.getNextRetryTime() == null) {
            task.setNextRetryTime(System.currentTimeMillis());
        } else {
            task.setNextRetryTime(scheduleItem.getNextRetryTime());
        }
        if (null != scheduleItem.getId()) {
            task.setId(scheduleItem.getId());
        }
        if (null != scheduleItem.getIsCycle()) {
            task.setIsCycle(scheduleItem.getIsCycle());
        }
        task.setErrorLog(scheduleItem.getErrorLog());
        task.setParam(scheduleItem.getParam());
        task.setApplication(scheduleItem.getApplication());
        task.setRemark(scheduleItem.getRemark());
        task.setRetryNums(0);
        task.setStatus(ScheduleStatusConst.EXECUTE.byteValue());
        task.setTaskType(scheduleItem.getTaskType());
        task.setCreateDate(new Timestamp(System.currentTimeMillis()));
        task.setOwnSign(OwnSignManager.ownSign);
        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
        int ampm = ScheduleDayWeek.getAmPm();
        task.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
        logger.info("tableNum:" + ScheduleTable.getNum(dayWeek, ampm) + " | dayWeek: " + dayWeek + " | ampm: " + ampm);
        this.commonScheduleItemDAO.insert(task);
    }

    @Override
    public ResultList<ScheduleItem> queryList(Query<ScheduleQuery> query) {
        ResultList result = new ResultList();
        if (null == query || null == query.getData()) {
            result.setErrorMessage("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        ScheduleQuery scheduleQuery = (ScheduleQuery)((Object)query.getData());
        if (null == scheduleQuery.getDayWeek() || null == scheduleQuery.getAmpm()) {
            int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
            int ampm = ScheduleDayWeek.getAmPm();
            scheduleQuery.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
        } else {
            scheduleQuery.setTableNum(ScheduleTable.getNum(scheduleQuery.getDayWeek(), scheduleQuery.getAmpm()));
        }
        query.setData((Object)scheduleQuery);
        long total = this.commonScheduleItemDAO.countListCommon(query);
        List<ScheduleItem> list = this.commonScheduleItemDAO.selectListCommon(query);
        result.setDatalist(list);
        result.setTotal(total);
        return result;
    }

    @Override
    public Result<Void> removeList(ScheduleItem scheduleItem) {
        ScheduleItem record = new ScheduleItem();
        record.setIds(scheduleItem.getIds());
        record.setRemark(scheduleItem.getRemark());
        record.setTableNum(scheduleItem.getTableNum());
        this.commonScheduleItemDAO.deleteScheduleTask(record);
        return new Result();
    }

    @Override
    public Result<Void> modify(ScheduleItem scheduleItem) {
        ScheduleItem record = new ScheduleItem();
        record.setParam(scheduleItem.getParam());
        record.setBizStatus(scheduleItem.getBizStatus());
        record.setNextRetryTime(scheduleItem.getNextRetryTime());
        record.setRemark(scheduleItem.getRemark());
        record.setRetryNums(scheduleItem.getRetryNums());
        record.setTableNum(scheduleItem.getTableNum());
        this.commonScheduleItemDAO.updateById(record);
        return new Result();
    }

    private List<ScheduleItem> selectScheduleDelayList(ScheduleQuery scheduleQuery) {
        ScheduleQuery query = new ScheduleQuery();
        query.setIds(scheduleQuery.getIds());
        if (scheduleQuery.getTableNum() == null) {
            int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
            int ampm = ScheduleDayWeek.getAmPm();
            query.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
        } else {
            query.setTableNum(scheduleQuery.getTableNum());
        }
        return this.commonScheduleItemDAO.mselectDelayList(query);
    }

    @Override
    public Result<Void> transferScheduleList(final ScheduleItem scheduleItem) {
        Result result = new Result();
        if (null == scheduleItem.getIds() || scheduleItem.getIds().size() == 0) {
            result.setErrorMessage("\u53c2\u6570\u7a7a\uff01");
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        ScheduleQuery query = new ScheduleQuery();
        query.setIds(scheduleItem.getIds());
        query.setTableNum(scheduleItem.getTableNum());
        final List<ScheduleItem> resultList = this.selectScheduleDelayList(query);
        final ArrayList insertTrade = new ArrayList();
        this.transactionTemplateSchedule.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    ScheduleServiceImpl.this.commonScheduleItemDAO.update2TransferByIds(scheduleItem);
                    Iterator iterator = resultList.iterator();
                    while (iterator.hasNext()) {
                        ScheduleItem s;
                        s.setRemark((s = (ScheduleItem)iterator.next()).getRemark() != null ? s.getRemark() + ",\u5de5\u5177\u8fc1\u79fb\u8fc7\u6765\u7684ID:" + s.getId() : "\u5de5\u5177\u8fc1\u79fb\u8fc7\u6765\u7684ID:" + s.getId());
                        s.setId(null);
                        s.setRetryNums(0);
                        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
                        int ampm = ScheduleDayWeek.getAmPm();
                        String nowTableNum = ScheduleTable.getNum(dayWeek, ampm);
                        s.setTableNum(nowTableNum);
                        insertTrade.add(s);
                    }
                    for (ScheduleItem scheduleItem1 : insertTrade) {
                        int r = ScheduleServiceImpl.this.commonScheduleItemDAO.insert(scheduleItem1);
                        if (r != 0) continue;
                        logger.error("\u6279\u91cf\u63d2\u5165\u8fc1\u79fb\u4efb\u52a1\u5931\u8d25\uff0c\u56de\u9000\u66f4\u6539!");
                        status.setRollbackOnly();
                        break;
                    }
                }
                catch (Throwable e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    status.setRollbackOnly();
                }
            }
        });
        return result;
    }
}

