/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.task.asyncTask;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.schedule.client.constant.ErrorCodeConstants;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.model.BaseAsyncScheduleTask;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.service.CommonTaskAction;
import com.naivete.framework.schedule.core.IScheduleTaskDealSingle;
import com.naivete.framework.schedule.core.TaskItemDefine;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class SerialBaseScheduleTask
extends BaseAsyncScheduleTask
implements IScheduleTaskDealSingle<List<ScheduleItem>> {
    private static Logger logger = LoggerFactory.getLogger(SerialBaseScheduleTask.class);

    public List<List<ScheduleItem>> selectTasks(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        return this.selectScheduleItemsForSerial(taskParameter, ownSign, taskItemNum, taskItemList, eachFetchDataNum);
    }

    public boolean execute(List<ScheduleItem> tasks, String ownSign) {
        for (final ScheduleItem task : tasks) {
            int i;
            final Result result = new Result();
            logger.info(task.getBizId() + ":" + task.getTaskType() + ":" + task.getBizStatus() + ":" + OwnSignManager.ownSign);
            final List<CommonTaskAction> taskActions = this.commonTaskActionManager.getTaskAction(task.getTaskType());
            if (taskActions == null || taskActions.size() == 0) {
                logger.error("taskActions==null||taskActions.size()==0");
                return false;
            }
            try {
                this.transactionTemplateSchedule.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        try {
                            for (CommonTaskAction taskAction : taskActions) {
                                Result<Void> taskExecuteRs = taskAction.execute(task);
                                if (!taskExecuteRs.isSuccess() && ErrorCodeConstants.BKCYCLE88888888.getErrorCode() == taskExecuteRs.getErrorCode() && task.getIsCycle().equals(1)) {
                                    result.setSuccess(true);
                                    return;
                                }
                                if (taskExecuteRs.isSuccess()) continue;
                                result.setSuccess(false);
                                result.setErrorMessage(taskAction.getActionType() + "\u6267\u884c\u5931\u8d25: " + taskExecuteRs.getErrorCode() + "," + taskExecuteRs.getErrorName() + "," + taskExecuteRs.getErrorMessage());
                                status.setRollbackOnly();
                                return;
                            }
                            int i = 0;
                            task.setModifyDate(new Timestamp(System.currentTimeMillis()));
                            i = SerialBaseScheduleTask.this.commonScheduleItemDAO.update2SucessByPrimaryKey(task);
                            if (i != 1) {
                                result.setSuccess(false);
                                result.setErrorMessage("\u6700\u540e\u66f4\u65b0schedule\u5931\u8d25");
                                status.setRollbackOnly();
                                return;
                            }
                        }
                        catch (Throwable e) {
                            result.setSuccess(false);
                            result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            status.setRollbackOnly();
                        }
                    }
                });
            }
            catch (Throwable e) {
                result.setSuccess(false);
                result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (result.isSuccess()) continue;
            int delay = 60000 * (task.getRetryNums() + 1);
            if (task.getRetryNums() <= 3) {
                delay = (int)(Math.random() * 1000.0 * 10.0 * (double)task.getRetryNums().intValue());
            }
            if (null != task.getIsCycle() && task.getIsCycle().equals(1)) {
                task.setNextRetryTime(System.currentTimeMillis() + (long)delay);
                task.setErrorLog(result.getErrorMessage().substring(0, result.getErrorMessage().length() > 2048 ? 2048 : result.getErrorMessage().length()));
                i = this.commonScheduleItemDAO.updateRetryCycleByPrimaryKey(task);
                if (i == 1) continue;
                logger.error("\u8bbe\u7f6e\u91cd\u8bd5\u5931\u8d25\uff1atask.bid:" + task.getBizId() + ",task.id:" + task.getId());
                return true;
            }
            task.setNextRetryTime(System.currentTimeMillis() + (long)delay);
            task.setErrorLog(result.getErrorMessage().substring(0, result.getErrorMessage().length() > 2048 ? 2048 : result.getErrorMessage().length()));
            i = this.commonScheduleItemDAO.update2RetryByPrimaryKey(task);
            if (i == 1) continue;
            logger.error("\u8bbe\u7f6e\u91cd\u8bd5\u5931\u8d25\uff1atask.bid:" + task.getBizId() + ",task.id:" + task.getId());
            return true;
        }
        return true;
    }

    public Comparator<List<ScheduleItem>> getComparator() {
        return null;
    }
}

