/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.task;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.schedule.client.config.annotation.Task;
import com.naivete.framework.schedule.client.dao.ScheduleItemDAO;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.model.ScheduleQuery;
import com.naivete.framework.schedule.client.util.ScheduleDayWeek;
import com.naivete.framework.schedule.client.util.ScheduleTable;
import com.naivete.framework.schedule.core.IScheduleTaskDealSingle;
import com.naivete.framework.schedule.core.TaskItemDefine;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Task
public class DelayMsgTransferScheduleTask
implements IScheduleTaskDealSingle<ScheduleItem> {
    private static Logger logger = LoggerFactory.getLogger(DelayMsgTransferScheduleTask.class);
    @Resource
    private ScheduleItemDAO commonScheduleItemDAO;
    @Resource
    private TransactionTemplate transactionTemplateSchedule;

    public List<ScheduleItem> selectTasks(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        ScheduleQuery query = new ScheduleQuery();
        query.setNextRetryTime(System.currentTimeMillis());
        Integer[] taskList = new Integer[taskItemList.size()];
        int i = 0;
        for (TaskItemDefine taskDefine : taskItemList) {
            taskList[i] = Integer.valueOf(taskDefine.getTaskItemId());
            ++i;
        }
        query.setOwnSign(OwnSignManager.ownSign);
        query.setData(taskList);
        query.setPageSize(eachFetchDataNum);
        query.setOrderBy("next_retry_time");
        query.setTaskItemNum(taskItemNum);
        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
        int ampm = ScheduleDayWeek.getAmPm();
        String nowTableNum = ScheduleTable.getNum(dayWeek, ampm);
        int delayTableNum = Integer.valueOf(nowTableNum) - 1;
        if (delayTableNum == -1) {
            delayTableNum = 13;
        }
        query.setTableNum(String.format("%02d", delayTableNum));
        List<ScheduleItem> result = this.commonScheduleItemDAO.selectDelayList(query);
        logger.info("DelayMsgTransferScheduleTask selectTasks delay size :" + result.size());
        return result;
    }

    public boolean execute(final ScheduleItem task, String ownSign) {
        final Result result = new Result();
        int dayWeek = ScheduleDayWeek.getDayWeek(task.getCreateDate().getTime());
        int ampm = ScheduleDayWeek.getAmPm();
        task.setDayWeek(dayWeek);
        task.setAmpm(ampm);
        this.transactionTemplateSchedule.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    String remark;
                    int i = DelayMsgTransferScheduleTask.this.commonScheduleItemDAO.update2TransferByPrimaryKey(task);
                    if (i != 1) {
                        result.setSuccess(false);
                        result.setErrorMessage("DelayMsgTransferScheduleTask\u6700\u540e\u66f4\u65b0schedule\u5931\u8d25");
                        status.setRollbackOnly();
                        return;
                    }
                    String string = remark = task.getRemark() != null ? task.getRemark() + ",\u8fc1\u79fb\u8fc7\u6765\u7684id" + task.getId() : "\u8fc1\u79fb\u8fc7\u6765\u7684id" + task.getId();
                    if (remark.length() > 1024) {
                        remark = remark.substring(remark.length() - 1024);
                    }
                    task.setRemark(remark);
                    task.setCreateDate(new Timestamp(System.currentTimeMillis()));
                    task.setId(null);
                    int dayWeek = ScheduleDayWeek.getDayWeek(task.getCreateDate().getTime());
                    int ampm = ScheduleDayWeek.getAmPm();
                    task.setDayWeek(dayWeek);
                    task.setRetryNums(0);
                    task.setAmpm(ampm);
                    task.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
                    DelayMsgTransferScheduleTask.this.commonScheduleItemDAO.insert(task);
                }
                catch (Throwable e) {
                    result.setSuccess(Boolean.FALSE.booleanValue());
                    result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    status.setRollbackOnly();
                }
            }
        });
        return true;
    }

    public Comparator<ScheduleItem> getComparator() {
        return null;
    }
}

