/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.task.asyncTask;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.model.BaseAsyncScheduleTask;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.service.CommonTaskAction;
import com.naivete.framework.schedule.core.IScheduleTaskDealSingle;
import com.naivete.framework.schedule.core.TaskItemDefine;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialBaseScheduleNoTransactionTask
extends BaseAsyncScheduleTask
implements IScheduleTaskDealSingle<List<ScheduleItem>> {
    private static Logger logger = LoggerFactory.getLogger(SerialBaseScheduleNoTransactionTask.class);

    public List<List<ScheduleItem>> selectTasks(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        return this.selectScheduleItemsForSerial(taskParameter, ownSign, taskItemNum, taskItemList, eachFetchDataNum);
    }

    public boolean execute(List<ScheduleItem> tasks, String ownSign) {
        for (ScheduleItem task : tasks) {
            Result result = new Result();
            logger.info(task.getBizId() + ":" + task.getTaskType() + ":" + task.getBizStatus() + ":" + OwnSignManager.ownSign);
            List<CommonTaskAction> taskActions = this.commonTaskActionManager.getTaskAction(task.getTaskType());
            if (taskActions == null || taskActions.size() == 0) {
                logger.error("taskActions==null||taskActions.size()==0");
                return false;
            }
            try {
                for (CommonTaskAction taskAction : taskActions) {
                    Result<Void> taskExecuteRs = taskAction.execute(task);
                    if (taskExecuteRs.isSuccess()) continue;
                    result.setSuccess(false);
                    result.setErrorMessage(taskAction.getActionType() + "\u6267\u884c\u5931\u8d25: " + taskExecuteRs.getErrorCode() + "," + taskExecuteRs.getErrorName() + "," + taskExecuteRs.getErrorMessage());
                }
                int i = 0;
                task.setModifyDate(new Timestamp(System.currentTimeMillis()));
                if (result.isSuccess() && (i = this.commonScheduleItemDAO.update2SucessByPrimaryKey(task)) != 1) {
                    result.setSuccess(false);
                    result.setErrorMessage("\u6700\u540e\u66f4\u65b0schedule\u5931\u8d25");
                }
            }
            catch (Throwable e) {
                result.setSuccess(false);
                result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (result.isSuccess()) continue;
            int delay = 60000 * (task.getRetryNums() + 1);
            if (task.getRetryNums() <= 3) {
                delay = (int)(Math.random() * 1000.0 * 10.0 * (double)task.getRetryNums().intValue());
            }
            task.setNextRetryTime(System.currentTimeMillis() + (long)delay);
            task.setErrorLog(result.getErrorMessage().substring(0, result.getErrorMessage().length() > 2048 ? 2048 : result.getErrorMessage().length()));
            int i = this.commonScheduleItemDAO.update2RetryByPrimaryKey(task);
            if (i == 1) continue;
            logger.error("\u8bbe\u7f6e\u91cd\u8bd5\u5931\u8d25\uff1atask.bid:" + task.getBizId() + ",task.id:" + task.getId());
            return true;
        }
        return true;
    }

    public Comparator<List<ScheduleItem>> getComparator() {
        return null;
    }
}

