/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.schedule.client.task.asyncTask;

import com.naivete.framework.common.dao.Result;
import com.naivete.framework.schedule.client.constant.ErrorCodeConstants;
import com.naivete.framework.schedule.client.dao.ScheduleItemDAO;
import com.naivete.framework.schedule.client.manager.OwnSignManager;
import com.naivete.framework.schedule.client.manager.TaskActionManager;
import com.naivete.framework.schedule.client.model.ScheduleItem;
import com.naivete.framework.schedule.client.model.ScheduleQuery;
import com.naivete.framework.schedule.client.service.CommonTaskAction;
import com.naivete.framework.schedule.client.util.ScheduleDayWeek;
import com.naivete.framework.schedule.client.util.ScheduleTable;
import com.naivete.framework.schedule.core.IScheduleTaskDealSingle;
import com.naivete.framework.schedule.core.TaskItemDefine;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class SerialBaseScheduleTypesTask
implements IScheduleTaskDealSingle<List<ScheduleItem>> {
    private static Logger logger = LoggerFactory.getLogger(SerialBaseScheduleTypesTask.class);
    private TransactionTemplate transactionTemplateSchedule;
    private ScheduleItemDAO commonScheduleItemDAO;
    private TaskActionManager commonTaskActionManager;
    private Map<String, String> taskTypeMap;

    public List<List<ScheduleItem>> selectTasks(String taskParameter, String ownSign, int taskItemNum, List<TaskItemDefine> taskItemList, int eachFetchDataNum) {
        ScheduleQuery query = new ScheduleQuery();
        query.setNextRetryTime(System.currentTimeMillis());
        Integer[] taskList = new Integer[taskItemList.size()];
        int i = 0;
        for (TaskItemDefine taskDefine : taskItemList) {
            taskList[i] = Integer.valueOf(taskDefine.getTaskItemId());
            ++i;
        }
        query.setOwnSign(OwnSignManager.ownSign);
        query.setData(taskList);
        query.setPageSize(eachFetchDataNum);
        query.setOrderBy("next_retry_time");
        query.setTaskItemNum(taskItemNum);
        query.setTaskTypes(this.getTaskTypeMap().keySet().toArray(new String[this.getTaskTypeMap().size()]));
        int dayWeek = ScheduleDayWeek.getDayWeek(System.currentTimeMillis());
        int ampm = ScheduleDayWeek.getAmPm();
        query.setTableNum(ScheduleTable.getNum(dayWeek, ampm));
        List<ScheduleItem> resultTemp = this.commonScheduleItemDAO.selectTypesListForSerial(query);
        if (resultTemp == null || resultTemp.size() == 0) {
            return null;
        }
        HashMap<String, ArrayList<ScheduleItem>> result = new HashMap<String, ArrayList<ScheduleItem>>();
        for (ScheduleItem scheduleItem : resultTemp) {
            String bizId = scheduleItem.getBizId();
            ArrayList<ScheduleItem> scheduleItems = (ArrayList<ScheduleItem>)result.get(bizId);
            if (scheduleItems == null) {
                scheduleItems = new ArrayList<ScheduleItem>();
                result.put(bizId, scheduleItems);
            }
            scheduleItems.add(scheduleItem);
        }
        return new ArrayList<List<ScheduleItem>>(result.values());
    }

    public boolean execute(List<ScheduleItem> tasks, String ownSign) {
        for (final ScheduleItem task : tasks) {
            final Result result = new Result();
            logger.info(task.getBizId() + ":" + task.getTaskType() + ":" + task.getBizStatus() + ":" + OwnSignManager.ownSign);
            final List<CommonTaskAction> taskActions = this.commonTaskActionManager.getTaskAction(task.getTaskType());
            if (taskActions == null || taskActions.size() == 0) {
                logger.error("taskActions==null||taskActions.size()==0");
                return false;
            }
            String transaction = this.getTaskTypeMap().get(task.getTaskType());
            if ("transaction".equals(transaction)) {
                try {
                    this.transactionTemplateSchedule.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            try {
                                for (CommonTaskAction taskAction : taskActions) {
                                    Result<Void> taskExecuteRs = taskAction.execute(task);
                                    if (!taskExecuteRs.isSuccess() && ErrorCodeConstants.BKCYCLE88888888.getErrorCode() == taskExecuteRs.getErrorCode() && task.getIsCycle().equals(1)) {
                                        result.setSuccess(true);
                                        return;
                                    }
                                    if (taskExecuteRs.isSuccess()) continue;
                                    result.setSuccess(false);
                                    result.setErrorMessage(taskAction.getActionType() + "\u6267\u884c\u5931\u8d25: " + taskExecuteRs.getErrorCode() + "," + taskExecuteRs.getErrorName() + "," + taskExecuteRs.getErrorMessage());
                                    status.setRollbackOnly();
                                    return;
                                }
                                int i = 0;
                                task.setModifyDate(new Timestamp(System.currentTimeMillis()));
                                i = SerialBaseScheduleTypesTask.this.commonScheduleItemDAO.update2SucessByPrimaryKey(task);
                                if (i != 1) {
                                    result.setSuccess(false);
                                    result.setErrorMessage("\u6700\u540e\u66f4\u65b0schedule\u5931\u8d25");
                                    status.setRollbackOnly();
                                    return;
                                }
                            }
                            catch (Throwable e) {
                                result.setSuccess(false);
                                result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                                status.setRollbackOnly();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    result.setSuccess(false);
                    result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            } else {
                try {
                    for (CommonTaskAction taskAction : taskActions) {
                        Result<Void> taskExecuteRs = taskAction.execute(task);
                        if (taskExecuteRs.isSuccess()) continue;
                        result.setSuccess(false);
                        result.setErrorMessage(taskAction.getActionType() + "\u6267\u884c\u5931\u8d25: " + taskExecuteRs.getErrorCode() + "," + taskExecuteRs.getErrorName() + "," + taskExecuteRs.getErrorMessage());
                        break;
                    }
                    task.setModifyDate(new Timestamp(System.currentTimeMillis()));
                    if (result.isSuccess()) {
                        int i = 0;
                        i = this.commonScheduleItemDAO.update2SucessByPrimaryKey(task);
                        if (i != 1) {
                            result.setSuccess(false);
                            result.setErrorMessage("\u6700\u540e\u66f4\u65b0schedule\u5931\u8d25");
                        }
                    }
                }
                catch (Throwable e) {
                    result.setSuccess(false);
                    result.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)e));
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (result.isSuccess()) continue;
            int delay = 60000 * (task.getRetryNums() + 1);
            if (task.getRetryNums() <= 3) {
                delay = (int)(Math.random() * 1000.0 * 10.0 * (double)task.getRetryNums().intValue());
            }
            task.setNextRetryTime(System.currentTimeMillis() + (long)delay);
            task.setErrorLog(result.getErrorMessage().substring(0, result.getErrorMessage().length() > 2048 ? 2048 : result.getErrorMessage().length()));
            int i = this.commonScheduleItemDAO.update2RetryByPrimaryKey(task);
            if (i == 1) continue;
            logger.error("\u8bbe\u7f6e\u91cd\u8bd5\u5931\u8d25\uff1atask.bid:" + task.getBizId() + ",task.id:" + task.getId());
            return true;
        }
        return true;
    }

    public Comparator<List<ScheduleItem>> getComparator() {
        return null;
    }

    public void setCommonScheduleItemDAO(ScheduleItemDAO commonScheduleItemDAO) {
        this.commonScheduleItemDAO = commonScheduleItemDAO;
    }

    public void setCommonTaskActionManager(TaskActionManager commonTaskActionManager) {
        this.commonTaskActionManager = commonTaskActionManager;
    }

    public Map<String, String> getTaskTypeMap() {
        return this.taskTypeMap;
    }

    public void setTaskTypeMap(Map<String, String> taskTypeMap) {
        this.taskTypeMap = taskTypeMap;
    }

    public void setTransactionTemplateSchedule(TransactionTemplate transactionTemplateSchedule) {
        this.transactionTemplateSchedule = transactionTemplateSchedule;
    }
}

