/*
 * Decompiled with CFR 0.152.
 */
package top.newleaf.mongo.codec;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Transient;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanCodec<T>
implements CollectibleCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCodec.class);
    private static final String ID_FIELD = "_id";
    private final Codec<Document> documentCodec = new DocumentCodec();
    private Class<T> tClass;

    public T generateIdIfAbsentFromDocument(T t) {
        return t;
    }

    public boolean documentHasId(T t) {
        return false;
    }

    public BsonValue getDocumentId(T t) {
        return null;
    }

    public T decode(BsonReader bsonReader, DecoderContext decoderContext) {
        Document document = (Document)this.documentCodec.decode(bsonReader, decoderContext);
        Class<T> tClass = this.getTClass();
        try {
            Field[] fields;
            T t = tClass.newInstance();
            for (Field field : fields = tClass.getDeclaredFields()) {
                this.setField(t, document, field);
            }
            return t;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public void encode(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        Field[] fields;
        Document document = new Document();
        for (Field field : fields = this.tClass.getDeclaredFields()) {
            this.setColumn(t, document, field);
        }
        this.documentCodec.encode(bsonWriter, (Object)document, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.getTClass();
    }

    private void setColumn(Object obj, Document document, Field field) {
        try {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Transient.class)) {
                Column column = field.getAnnotation(Column.class);
                String columnName = column != null ? column.name() : this.getColumnName(field.getName());
                if (obj == null) {
                    document.put(columnName, null);
                } else {
                    String methodGetName = this.getMethodGetName(field);
                    Method method = obj.getClass().getMethod(methodGetName, new Class[0]);
                    Object value = method.invoke(obj, new Object[0]);
                    value = this.setGenericColumn(field, value);
                    if (!ID_FIELD.equals(columnName)) {
                        document.put(columnName, value);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void setField(Object obj, Document document, Field field) {
        try {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Transient.class)) {
                Object value;
                Column column = field.getAnnotation(Column.class);
                String columnName = column != null ? column.name() : this.getColumnName(field.getName());
                if (ID_FIELD.equals(columnName)) {
                    value = document.getObjectId((Object)ID_FIELD).toString();
                } else {
                    Object defaultVal = field.get(obj);
                    value = document.get((Object)columnName);
                    if (value == null && defaultVal != null) {
                        value = defaultVal;
                    }
                }
                value = this.setGenericField(field, value);
                String setMethodName = this.getMethodSetName(field);
                Class<?> fieldClass = field.getType();
                Method method = obj.getClass().getMethod(setMethodName, fieldClass);
                method.invoke(obj, value);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private Class<T> getTClass() {
        if (this.tClass == null) {
            this.tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        return this.tClass;
    }

    private Object setGenericColumn(Field field, Object value) {
        if (value == null) {
            return value;
        }
        if (field.getType() == List.class) {
            Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (this.isGenericType(genericType)) {
                ArrayList<Document> documents = new ArrayList<Document>();
                Field[] fields = genericType.getDeclaredFields();
                for (Object obj : (List)value) {
                    Document document = new Document();
                    for (Field f : fields) {
                        this.setColumn(obj, document, f);
                    }
                    documents.add(document);
                }
                value = documents;
            }
        } else if (this.isGenericType(field.getType())) {
            Field[] fields = field.getType().getDeclaredFields();
            Document document = new Document();
            for (Field f : fields) {
                this.setColumn(value, document, f);
            }
            value = document;
        }
        return value;
    }

    private Object setGenericField(Field field, Object value) {
        if (value == null) {
            return value;
        }
        ArrayList object = value;
        if (field.getType() == List.class) {
            Class genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (this.isGenericType(genericType)) {
                ArrayList genericList = new ArrayList();
                Field[] fields = genericType.getDeclaredFields();
                for (Document document : (List)value) {
                    try {
                        Object genericObj = genericType.newInstance();
                        for (Field genericField : fields) {
                            this.setField(genericObj, document, genericField);
                        }
                        genericList.add(genericObj);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u521d\u59cb\u5316List\u6cdb\u578b\u5bf9\u8c61\u5931\u8d25\uff0cfiled = {}", (Object)field.getName(), (Object)e);
                    }
                }
                object = genericList;
            }
        } else if (this.isGenericType(field.getType())) {
            try {
                Field[] fields = field.getType().getDeclaredFields();
                object = field.getType().newInstance();
                for (Field f : fields) {
                    this.setField(object, (Document)value, f);
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return object;
    }

    private boolean isGenericType(Class<?> clazz) {
        return !clazz.isPrimitive() && !Number.class.isAssignableFrom(clazz) && !String.class.isAssignableFrom(clazz) && !Boolean.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz) && !BasicDBObject.class.isAssignableFrom(clazz) && !BasicDBList.class.isAssignableFrom(clazz);
    }

    private String getColumnName(String fieldName) {
        StringBuilder column = new StringBuilder(fieldName);
        int count = 0;
        for (int i = 0; i < fieldName.length(); ++i) {
            char sBefore;
            char s = fieldName.charAt(i);
            if (s < 'A' || s > 'Z' || i <= 0 || (sBefore = fieldName.charAt(i - 1)) >= 'A' && sBefore <= 'Z') continue;
            column.replace(i + count, i + count + 1, "_" + Character.toLowerCase(s));
            ++count;
        }
        return column.toString();
    }

    private String getMethodSetName(Field field) {
        String name = field.getName();
        return "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private String getMethodGetName(Field field) {
        String name = field.getName();
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

