/*
 * Decompiled with CFR 0.152.
 */
package top.newleaf.mongo.factory;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import top.newleaf.mongo.factory.MongoFactory;

public class MongoDB {
    private String name;
    private MongoDatabase mongoDatabase;

    public MongoDB() {
    }

    public MongoDB(String name, MongoDatabase mongoDatabase) {
        this.name = name;
        this.mongoDatabase = mongoDatabase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public <T> MongoCollection<T> getCollection(Class<T> clazz) {
        String collName = MongoFactory.getInstance().getCollectionName(clazz);
        if (collName != null) {
            return this.getCollection(collName, clazz);
        }
        return null;
    }

    public MongoCollection<Document> getCollection(String collName) {
        return this.mongoDatabase.getCollection(collName);
    }

    public <T> MongoCollection<T> getCollection(String collName, Class<T> clazz) {
        if (collName != null) {
            return this.mongoDatabase.getCollection(collName, clazz);
        }
        return null;
    }
}

