/*
 * Decompiled with CFR 0.152.
 */
package top.newleaf.mongo.factory;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Table;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.newleaf.mongo.factory.MongoConnection;
import top.newleaf.mongo.factory.MongoDB;
import top.newleaf.mongo.scanner.BeanCodecScanAction;
import top.newleaf.mongo.scanner.ClassScanner;

public class MongoFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoFactory.class);
    private static final String CONF_NAME = "mongo.xml";
    private static Map<String, MongoDB> dbs = new HashMap<String, MongoDB>();
    private static MongoFactory instance = new MongoFactory();
    private ConcurrentHashMap<Class<?>, String> tables = new ConcurrentHashMap();
    private MongoDB defaultDb;
    private boolean hasInit = false;

    private MongoFactory() {
    }

    public static MongoFactory getInstance() {
        return instance;
    }

    public static MongoDB getDb() {
        return MongoFactory.instance.defaultDb;
    }

    public static MongoDB getDb(String name) {
        return dbs.get(name);
    }

    public static Map<String, MongoDB> getDbs() {
        return dbs;
    }

    public boolean getHasInit() {
        return this.hasInit;
    }

    public String getCollectionName(Class<?> clazz) {
        String collName = this.tables.get(clazz);
        if (collName == null) {
            Table table = clazz.getAnnotation(Table.class);
            if (table != null && !"".equals(table.name())) {
                collName = table.name();
                this.tables.put(clazz, collName);
            }
            if (collName == null) {
                throw new IllegalArgumentException(clazz.getName() + "\u672a\u6307\u5b9a\u8868\u540d");
            }
        }
        return collName;
    }

    public void init(String confPath) {
        try {
            Document document = this.loadXml(confPath);
            List packageNodes = document.selectNodes("mongo/packages/package");
            HashSet<String> packages = new HashSet<String>();
            if (packages != null) {
                for (Node packageNode : packageNodes) {
                    packages.add(packageNode.getText());
                }
            }
            BeanCodecScanAction scanAction = new BeanCodecScanAction();
            ClassScanner.scan(packages, true, scanAction);
            List<MongoConnection> connections = this.parseMongoConnection(document);
            if (!connections.isEmpty()) {
                this.createConnections(connections, scanAction.getCodecSet());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316mongo\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnections(List<MongoConnection> connections, Set<? extends Codec> codecSet) {
        if (!this.hasInit && !connections.isEmpty()) {
            MongoFactory mongoFactory = instance;
            synchronized (mongoFactory) {
                if (!this.hasInit) {
                    this.hasInit = true;
                    for (MongoConnection connection : connections) {
                        MongoClientOptions.Builder build = new MongoClientOptions.Builder();
                        if (codecSet.size() > 0) {
                            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])codecSet.toArray(new Codec[codecSet.size()])), MongoClient.getDefaultCodecRegistry()});
                            build.codecRegistry(codecRegistry);
                        }
                        MongoClientURI mongoURI = new MongoClientURI(connection.getUri(), build);
                        MongoClient client = new MongoClient(mongoURI);
                        MongoDatabase db = client.getDatabase(connection.getDb());
                        MongoDB mongoDB = new MongoDB(connection.getName(), db);
                        dbs.put(connection.getName(), mongoDB);
                        if (!connection.getIsDefault()) continue;
                        this.defaultDb = mongoDB;
                    }
                }
            }
        }
    }

    private Document loadXml(String confPath) {
        Document document;
        block18: {
            SAXReader reader = new SAXReader();
            document = null;
            try {
                if (confPath == null || confPath.isEmpty()) {
                    try (InputStream inputStream = MongoFactory.class.getClassLoader().getResourceAsStream(CONF_NAME);){
                        if (inputStream != null) {
                            document = reader.read(inputStream);
                            LOGGER.warn("\u672a\u6307\u5b9a\u5177\u4f53mongo.xml\u914d\u7f6e\uff0c\u5728\u7c7b\u8def\u5f84\u52a0\u8f7d");
                        }
                        break block18;
                    }
                }
                if (!confPath.endsWith(CONF_NAME)) {
                    confPath = confPath.endsWith("/") ? confPath + CONF_NAME : confPath + "/" + CONF_NAME;
                }
                document = reader.read(confPath);
            }
            catch (Exception e) {
                LOGGER.error("\u8bfb\u53d6mongo.xml\u9519\u8bef", (Throwable)e);
            }
        }
        if (document == null) {
            throw new RuntimeException("\u672a\u68c0\u6d4b\u5230mongo.xml\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u8def\u5f84\u662f\u5426\u6b63\u786e");
        }
        return document;
    }

    private List<MongoConnection> parseMongoConnection(Document document) {
        ArrayList<MongoConnection> connections = new ArrayList<MongoConnection>();
        List connectionNodes = document.selectNodes("mongo/connections/connection");
        if (connectionNodes != null) {
            for (Node connectionNode : connectionNodes) {
                String uri = connectionNode.selectSingleNode("uri").getText();
                String dbName = connectionNode.selectSingleNode("db").getText();
                String name = connectionNode.selectSingleNode("name").getText();
                Node isDefaultNode = connectionNode.selectSingleNode("isDefault");
                boolean isDefault = false;
                if (isDefaultNode != null) {
                    isDefault = Boolean.valueOf(isDefaultNode.getText());
                }
                connections.add(new MongoConnection(uri, dbName, name, isDefault));
            }
        }
        return connections;
    }
}

