/*
 * Decompiled with CFR 0.152.
 */
package top.newleaf.mongo.scanner;

import java.util.HashSet;
import java.util.Set;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.newleaf.mongo.codec.BeanCodec;
import top.newleaf.mongo.scanner.IScanAction;

public class BeanCodecScanAction
implements IScanAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanCodecScanAction.class);
    private Set<Codec> codecSet = new HashSet<Codec>();

    @Override
    public void doAction(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (CollectibleCodec.class.isAssignableFrom(clazz) && BeanCodec.class != clazz) {
                this.codecSet.add((Codec)clazz.newInstance());
                LOGGER.info("add codec : {}", (Object)className);
            }
        }
        catch (Throwable e) {
            LOGGER.error("load class faild : {}", (Object)className, (Object)e);
        }
    }

    public Set<Codec> getCodecSet() {
        return this.codecSet;
    }
}

