/*
 * Decompiled with CFR 0.152.
 */
package top.newleaf.mongo.scanner;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.newleaf.mongo.scanner.IScanAction;

public class ClassScanner {
    public static void scan(Set<String> scanPackages, boolean recursive, IScanAction scanAction) throws Exception {
        if (scanPackages != null && !scanPackages.isEmpty()) {
            for (String scanPackage : scanPackages) {
                String scanPath = scanPackage.replaceAll("\\.", "/");
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Enumeration<URL> urls = loader.getResources(scanPath);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (url == null) continue;
                    String protocol = url.getProtocol();
                    String pkgPath = url.getPath();
                    if ("file".equals(protocol)) {
                        ClassScanner.scanClassNameFromDir(scanPackage, pkgPath, recursive, scanAction);
                        continue;
                    }
                    if (!"jar".equals(protocol)) continue;
                    ClassScanner.scanClassNameFromJar(scanPackage, url, recursive, scanAction);
                }
            }
        }
    }

    private static void scanClassNameFromDir(String scanPackage, String pkgPath, boolean recursive, IScanAction scanAction) {
        File[] files = new File(pkgPath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || recursive && file.isDirectory());
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                if (f.isFile()) {
                    String clazzName = ClassScanner.getClassName(scanPackage, fileName);
                    scanAction.doAction(clazzName);
                    continue;
                }
                if (!recursive) continue;
                String subPkgName = scanPackage + "." + fileName;
                String subPkgPath = pkgPath + "/" + fileName;
                ClassScanner.scanClassNameFromDir(subPkgName, subPkgPath, recursive, scanAction);
            }
        }
    }

    private static void scanClassNameFromJar(String scanPackage, URL url, boolean recursive, IScanAction scanAction) throws Exception {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (jarEntry.isDirectory() || !jarEntryName.endsWith(".class")) continue;
            String clazzName = jarEntryName.substring(0, jarEntryName.indexOf(46)).replace('/', '.');
            if (recursive) {
                if (!clazzName.startsWith(scanPackage)) continue;
                scanAction.doAction(clazzName);
                continue;
            }
            int index = clazzName.lastIndexOf(".");
            String pkg = index != -1 ? clazzName.substring(0, index) : "";
            if (!pkg.equals(scanPackage)) continue;
            scanAction.doAction(clazzName);
        }
    }

    private static String getClassName(String pkgName, String fileName) {
        int endIndex = fileName.lastIndexOf(".");
        String clazz = null;
        if (endIndex >= 0) {
            clazz = fileName.substring(0, endIndex);
        }
        String clazzName = null;
        if (clazz != null) {
            clazzName = pkgName + "." + clazz;
        }
        return clazzName;
    }
}

