/*
 * Decompiled with CFR 0.152.
 */
package top.newleaf.mongo.autoconfigure;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import top.newleaf.mongo.autoconfigure.MongoProperties;
import top.newleaf.mongo.codec.BeanCodec;
import top.newleaf.mongo.factory.MongoDB;
import top.newleaf.mongo.factory.MongoFactory;

public class MongoDBBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBBeanPostProcessor.class);
    @Autowired
    private ApplicationContext applicationContext;
    private MongoProperties mongoProperties;

    public MongoDBBeanPostProcessor(MongoProperties mongoProperties) {
        this.mongoProperties = mongoProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.initMongoConnections();
        this.populateMongoDB(bean);
        return bean;
    }

    private void populateMongoDB(Object bean) {
        Class<?> clazz = bean.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != MongoDB.class) continue;
            ReflectionUtils.makeAccessible((Field)field);
            Resource resource = (Resource)AnnotationUtils.findAnnotation((AnnotatedElement)field, Resource.class);
            if (resource != null && StringUtils.hasLength((String)resource.name())) {
                String name = resource.name();
                if (name.endsWith("DB")) {
                    name = name.substring(0, name.length() - 2);
                }
                ReflectionUtils.setField((Field)field, (Object)bean, (Object)MongoFactory.getDb((String)name));
                continue;
            }
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)MongoFactory.getDb());
        }
    }

    private void initMongoConnections() {
        if (!MongoFactory.getInstance().getHasInit()) {
            Map beanCodecs = this.applicationContext.getBeansOfType(BeanCodec.class);
            MongoFactory.getInstance().createConnections(this.mongoProperties.getConnections(), new HashSet(beanCodecs.values()));
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
            Map dbs = MongoFactory.getDbs();
            if (!dbs.isEmpty()) {
                dbs.forEach((name, db) -> {
                    String beanName = name + "DB";
                    if (!beanFactory.containsBean(beanName)) {
                        beanFactory.registerSingleton(name + "DB", db);
                        LOGGER.info("register mongoDB: {}", (Object)beanName);
                    }
                });
            }
        }
    }
}

