/*
 * Decompiled with CFR 0.152.
 */
package top.nkdark.gocq.boot;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import top.nkdark.gocq.boot.BotProperties;
import top.nkdark.gocq.boot.EventProperties;

@ComponentScan(value={"top.nkdark.gocq"})
@Configuration
@EnableWebSocket
@EnableConfigurationProperties(value={BotProperties.class, EventProperties.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltop/nkdark/gocq/boot/AutoConfiguration;", "Lorg/springframework/web/socket/config/annotation/WebSocketConfigurer;", "botProperties", "Ltop/nkdark/gocq/boot/BotProperties;", "webSocketHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "(Ltop/nkdark/gocq/boot/BotProperties;Lorg/springframework/web/socket/WebSocketHandler;)V", "getBotProperties", "()Ltop/nkdark/gocq/boot/BotProperties;", "getWebSocketHandler", "()Lorg/springframework/web/socket/WebSocketHandler;", "registerWebSocketHandlers", "", "registry", "Lorg/springframework/web/socket/config/annotation/WebSocketHandlerRegistry;", "gocq-spring-boot-starter"})
public class AutoConfiguration
implements WebSocketConfigurer {
    @NotNull
    private final BotProperties botProperties;
    @NotNull
    private final WebSocketHandler webSocketHandler;

    public AutoConfiguration(@NotNull BotProperties botProperties, @NotNull WebSocketHandler webSocketHandler) {
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        Intrinsics.checkNotNullParameter((Object)webSocketHandler, (String)"webSocketHandler");
        this.botProperties = botProperties;
        this.webSocketHandler = webSocketHandler;
    }

    @NotNull
    public BotProperties getBotProperties() {
        return this.botProperties;
    }

    @NotNull
    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    public void registerWebSocketHandlers(@NotNull WebSocketHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String[] stringArray = new String[]{this.getBotProperties().getUrl()};
        WebSocketHandlerRegistration webSocketHandlerRegistration = registry.addHandler(this.getWebSocketHandler(), stringArray);
        stringArray = new String[]{"*"};
        webSocketHandlerRegistration.setAllowedOrigins(stringArray);
    }
}

