/*
 * Decompiled with CFR 0.152.
 */
package top.nkdark.gocq.boot;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;
import top.nkdark.gocq.boot.BotProperties;
import top.nkdark.gocq.boot.EventProperties;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0017J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltop/nkdark/gocq/boot/BotBean;", "", "botProperties", "Ltop/nkdark/gocq/boot/BotProperties;", "eventProperties", "Ltop/nkdark/gocq/boot/EventProperties;", "(Ltop/nkdark/gocq/boot/BotProperties;Ltop/nkdark/gocq/boot/EventProperties;)V", "getBotProperties", "()Ltop/nkdark/gocq/boot/BotProperties;", "getEventProperties", "()Ltop/nkdark/gocq/boot/EventProperties;", "createExecutor", "Ljava/util/concurrent/ExecutorService;", "createWebSocketContainer", "Lorg/springframework/web/socket/server/standard/ServletServerContainerFactoryBean;", "gocq-spring-boot-starter"})
public class BotBean {
    @NotNull
    private final BotProperties botProperties;
    @NotNull
    private final EventProperties eventProperties;

    public BotBean(@NotNull BotProperties botProperties, @NotNull EventProperties eventProperties) {
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        Intrinsics.checkNotNullParameter((Object)eventProperties, (String)"eventProperties");
        this.botProperties = botProperties;
        this.eventProperties = eventProperties;
    }

    @NotNull
    public BotProperties getBotProperties() {
        return this.botProperties;
    }

    @NotNull
    public EventProperties getEventProperties() {
        return this.eventProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ExecutorService createExecutor() {
        return new ThreadPoolExecutor(this.getEventProperties().getCorePoolSize(), this.getEventProperties().getMaxPoolSize(), this.getEventProperties().getKeepAliveTime(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue(this.getEventProperties().getWorkQueueSize()));
    }

    @Bean
    @ConditionalOnMissingBean
    @Nullable
    public ServletServerContainerFactoryBean createWebSocketContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxSessionIdleTimeout(Long.valueOf(this.getBotProperties().getMaxSessionIdleTimeout()));
        container.setMaxTextMessageBufferSize(Integer.valueOf(this.getBotProperties().getMaxTextMessageBufferSize()));
        container.setMaxBinaryMessageBufferSize(Integer.valueOf(this.getBotProperties().getMaxBinaryMessageBufferSize()));
        return container;
    }
}

