/*
 * Decompiled with CFR 0.152.
 */
package top.nkdark.gocq.bot;

import com.alibaba.fastjson2.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;
import top.nkdark.gocq.boot.BotProperties;
import top.nkdark.gocq.bot.ApiEnum;
import top.nkdark.gocq.bot.ApiSender;
import top.nkdark.gocq.bot.IApiRequest;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0012J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\"\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ltop/nkdark/gocq/bot/ApiHandler;", "", "botProperties", "Ltop/nkdark/gocq/boot/BotProperties;", "(Ltop/nkdark/gocq/boot/BotProperties;)V", "apiCallbackMap", "Ljava/util/HashMap;", "", "Ltop/nkdark/gocq/bot/ApiSender;", "Lkotlin/collections/HashMap;", "apiEcho", "Ljava/util/concurrent/atomic/AtomicLong;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "constructApiJson", "Lcom/alibaba/fastjson2/JSONObject;", "action", "Ltop/nkdark/gocq/bot/ApiEnum;", "params", "apiRequest", "Ltop/nkdark/gocq/bot/IApiRequest;", "onReceiveApiMessage", "", "message", "sendApiMessage", "botSession", "Lorg/springframework/web/socket/WebSocketSession;", "gocq-spring-boot-starter"})
public class ApiHandler {
    @NotNull
    private final BotProperties botProperties;
    private final Logger log;
    @NotNull
    private AtomicLong apiEcho;
    @NotNull
    private final HashMap<String, ApiSender> apiCallbackMap;

    public ApiHandler(@NotNull BotProperties botProperties) {
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        this.botProperties = botProperties;
        this.log = LoggerFactory.getLogger(ApiHandler.class);
        this.apiEcho = new AtomicLong();
        this.apiCallbackMap = new HashMap();
    }

    public void onReceiveApiMessage(@NotNull JSONObject message) {
        ApiSender apiSender;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = message.get("echo");
        String echo = object != null ? object.toString() : null;
        ApiSender apiSender2 = apiSender = (ApiSender)((Map)this.apiCallbackMap).get(echo);
        if (apiSender2 != null) {
            apiSender2.onReceiveJson(message);
        }
        TypeIntrinsics.asMutableMap((Object)this.apiCallbackMap).remove(echo);
    }

    private JSONObject constructApiJson(IApiRequest apiRequest) {
        JSONObject apiJson = new JSONObject();
        ((Map)apiJson).put("action", apiRequest.getEndpoint());
        JSONObject jSONObject = apiRequest.getParams();
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            ((Map)apiJson).put("params", it);
        }
        ((Map)apiJson).put("echo", this.apiEcho.getAndIncrement());
        return apiJson;
    }

    private JSONObject constructApiJson(ApiEnum action, JSONObject params) {
        JSONObject apiJson = new JSONObject();
        ((Map)apiJson).put("action", action.getEndpoint());
        JSONObject jSONObject = params;
        if (jSONObject != null) {
            JSONObject it = jSONObject;
            boolean bl = false;
            ((Map)apiJson).put("params", it);
        }
        ((Map)apiJson).put("echo", this.apiEcho.getAndIncrement());
        return apiJson;
    }

    @NotNull
    public JSONObject sendApiMessage(@NotNull WebSocketSession botSession, @NotNull IApiRequest apiRequest) throws IOException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)botSession, (String)"botSession");
        Intrinsics.checkNotNullParameter((Object)apiRequest, (String)"apiRequest");
        JSONObject apiJson = this.constructApiJson(apiRequest);
        String echo = apiJson.getString("echo");
        ApiSender apiSender = new ApiSender(botSession, this.botProperties.getApiTimeout());
        Map map = this.apiCallbackMap;
        Intrinsics.checkNotNullExpressionValue((Object)echo, (String)"echo");
        map.put(echo, apiSender);
        return apiSender.sendApiJson(apiJson);
    }

    @NotNull
    public JSONObject sendApiMessage(@NotNull WebSocketSession botSession, @NotNull ApiEnum action, @Nullable JSONObject params) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)botSession, (String)"botSession");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        JSONObject apiJson = this.constructApiJson(action, params);
        String echo = apiJson.getString("echo");
        ApiSender apiSender = new ApiSender(botSession, this.botProperties.getApiTimeout());
        Map map = this.apiCallbackMap;
        Intrinsics.checkNotNullExpressionValue((Object)echo, (String)"echo");
        map.put(echo, apiSender);
        try {
            jSONObject = apiSender.sendApiJson(apiJson);
        }
        catch (Exception e) {
            this.log.error("Send Api message error: [" + action.getDescription() + ']', (Throwable)e);
            JSONObject retJson = new JSONObject();
            ((Map)retJson).put("status", "failed");
            ((Map)retJson).put("retcode", -1);
            jSONObject = retJson;
        }
        return jSONObject;
    }
}

