/*
 * Decompiled with CFR 0.152.
 */
package top.nkdark.gocq.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import top.nkdark.gocq.bot.ApiHandler;
import top.nkdark.gocq.bot.Bot;
import top.nkdark.gocq.bot.BotContainer;
import top.nkdark.gocq.bot.BotFactory;
import top.nkdark.gocq.handler.EventHandler;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltop/nkdark/gocq/handler/BotWebSocketHandler;", "Lorg/springframework/web/socket/handler/TextWebSocketHandler;", "botFactory", "Ltop/nkdark/gocq/bot/BotFactory;", "apiHandler", "Ltop/nkdark/gocq/bot/ApiHandler;", "eventHandler", "Ltop/nkdark/gocq/handler/EventHandler;", "executor", "Ljava/util/concurrent/ExecutorService;", "botContainer", "Ltop/nkdark/gocq/bot/BotContainer;", "(Ltop/nkdark/gocq/bot/BotFactory;Ltop/nkdark/gocq/bot/ApiHandler;Ltop/nkdark/gocq/handler/EventHandler;Ljava/util/concurrent/ExecutorService;Ltop/nkdark/gocq/bot/BotContainer;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterConnectionClosed", "", "session", "Lorg/springframework/web/socket/WebSocketSession;", "status", "Lorg/springframework/web/socket/CloseStatus;", "afterConnectionEstablished", "handleTextMessage", "message", "Lorg/springframework/web/socket/TextMessage;", "gocq-spring-boot-starter"})
public class BotWebSocketHandler
extends TextWebSocketHandler {
    @NotNull
    private final BotFactory botFactory;
    @NotNull
    private final ApiHandler apiHandler;
    @NotNull
    private final EventHandler eventHandler;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final BotContainer botContainer;
    private final Logger log;

    public BotWebSocketHandler(@NotNull BotFactory botFactory, @NotNull ApiHandler apiHandler, @NotNull EventHandler eventHandler, @NotNull ExecutorService executor, @NotNull BotContainer botContainer) {
        Intrinsics.checkNotNullParameter((Object)botFactory, (String)"botFactory");
        Intrinsics.checkNotNullParameter((Object)apiHandler, (String)"apiHandler");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)botContainer, (String)"botContainer");
        this.botFactory = botFactory;
        this.apiHandler = apiHandler;
        this.eventHandler = eventHandler;
        this.executor = executor;
        this.botContainer = botContainer;
        this.log = LoggerFactory.getLogger(BotWebSocketHandler.class);
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession session) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Object object = (List)session.getHandshakeHeaders().get((Object)"x-self-id");
            Long xSelfId = object != null && (object = (String)object.get(0)) != null ? Long.valueOf(Long.parseLong((String)object)) : null;
            this.log.info("{} connected", (Object)xSelfId);
            Long l = xSelfId;
            if (l == null) break block0;
            long uin = ((Number)l).longValue();
            boolean bl = false;
            Bot bot = this.botFactory.createBot(uin, session);
            Long l2 = uin;
            this.botContainer.getBots().put(l2, bot);
        }
    }

    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Object object = (List)session.getHandshakeHeaders().get((Object)"x-self-id");
        Long xSelfId = object != null && (object = (String)object.get(0)) != null ? Long.valueOf(Long.parseLong((String)object)) : null;
        this.log.info("{} disconnected", (Object)xSelfId);
        TypeIntrinsics.asMutableMap(this.botContainer.getBots()).remove(xSelfId);
    }

    protected void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage message) {
        block3: {
            Long xSelfId;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Object object = (List)session.getHandshakeHeaders().get((Object)"x-self-id");
            Long l = xSelfId = object != null && (object = (String)object.get(0)) != null ? Long.valueOf(Long.parseLong((String)object)) : null;
            if (l == null) break block3;
            long uin = ((Number)l).longValue();
            boolean bl = false;
            Bot bot = this.botContainer.getBots().get(uin);
            if (bot == null) {
                Bot bot2;
                Bot it = bot2 = this.botFactory.createBot(uin, session);
                boolean bl2 = false;
                Long l2 = uin;
                this.botContainer.getBots().put(l2, it);
                bot = bot2;
            }
            Bot bot3 = bot;
            bot3.setBotSession(session);
            JSONObject payloadJson = JSON.parseObject((String)((String)message.getPayload()));
            if (payloadJson.containsKey("echo")) {
                Intrinsics.checkNotNullExpressionValue((Object)payloadJson, (String)"payloadJson");
                this.apiHandler.onReceiveApiMessage(payloadJson);
            } else {
                this.executor.execute(() -> BotWebSocketHandler.handleTextMessage$lambda$3$lambda$2(this, bot3, payloadJson));
            }
        }
    }

    private static final void handleTextMessage$lambda$3$lambda$2(BotWebSocketHandler this$0, Bot $bot, JSONObject $payloadJson) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bot, (String)"$bot");
        EventHandler eventHandler = this$0.eventHandler;
        Intrinsics.checkNotNullExpressionValue((Object)$payloadJson, (String)"payloadJson");
        eventHandler.handle($bot, $payloadJson);
    }
}

