/*
 * Decompiled with CFR 0.152.
 */
package top.nkdark.gocq.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import top.nkdark.gocq.boot.BotProperties;
import top.nkdark.gocq.bot.Bot;
import top.nkdark.gocq.bot.BotPlugin;
import top.nkdark.gocq.proto.ClientStatusChangeNoticeEvent;
import top.nkdark.gocq.proto.EssenceNoticeEvent;
import top.nkdark.gocq.proto.FriendAddNoticeEvent;
import top.nkdark.gocq.proto.FriendPokeNoticeEvent;
import top.nkdark.gocq.proto.FriendRecallNoticeEvent;
import top.nkdark.gocq.proto.FriendRequestEvent;
import top.nkdark.gocq.proto.GroupAdminChangeNoticeEvent;
import top.nkdark.gocq.proto.GroupBanNoticeEvent;
import top.nkdark.gocq.proto.GroupCardUpdateNoticeEvent;
import top.nkdark.gocq.proto.GroupHonorChangeNoticeEvent;
import top.nkdark.gocq.proto.GroupLuckyKingChangeNoticeEvent;
import top.nkdark.gocq.proto.GroupMemberDecreaseNoticeEvent;
import top.nkdark.gocq.proto.GroupMemberIncreaseNoticeEvent;
import top.nkdark.gocq.proto.GroupMessageEvent;
import top.nkdark.gocq.proto.GroupPokeNoticeEvent;
import top.nkdark.gocq.proto.GroupRecallNoticeEvent;
import top.nkdark.gocq.proto.GroupRequestEvent;
import top.nkdark.gocq.proto.GroupTitleUpdateNoticeEvent;
import top.nkdark.gocq.proto.GroupUploadNoticeEvent;
import top.nkdark.gocq.proto.HeartbeatMetaEvent;
import top.nkdark.gocq.proto.LifecycleMetaEvent;
import top.nkdark.gocq.proto.OfflineFileNoticeEvent;
import top.nkdark.gocq.proto.PrivateMessageEvent;
import top.nkdark.gocq.proto.guild.ChannelCreatedNoticeEvent;
import top.nkdark.gocq.proto.guild.ChannelDestroyedNoticeEvent;
import top.nkdark.gocq.proto.guild.ChannelUpdatedNoticeEvent;
import top.nkdark.gocq.proto.guild.GuildMessageEvent;
import top.nkdark.gocq.proto.guild.MessageReactionsUpdatedNoticeEvent;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0012\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ltop/nkdark/gocq/handler/EventHandler;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "botProperties", "Ltop/nkdark/gocq/boot/BotProperties;", "(Lorg/springframework/context/ApplicationContext;Ltop/nkdark/gocq/boot/BotProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPlugin", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "handle", "", "bot", "Ltop/nkdark/gocq/bot/Bot;", "eventJson", "Lcom/alibaba/fastjson2/JSONObject;", "handleMessage", "handleMeta", "handleNotice", "handleNotify", "handlePoke", "handleRequest", "gocq-spring-boot-starter"})
public class EventHandler {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final BotProperties botProperties;
    private final Logger log;

    public EventHandler(@NotNull ApplicationContext applicationContext, @NotNull BotProperties botProperties) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        this.applicationContext = applicationContext;
        this.botProperties = botProperties;
        this.log = LoggerFactory.getLogger(EventHandler.class);
    }

    private <T> T getPlugin(Class<T> clazz) {
        Object object;
        try {
            object = this.applicationContext.getBean(clazz);
        }
        catch (Exception _) {
            object = null;
        }
        return (T)object;
    }

    public void handle(@NotNull Bot bot, @NotNull JSONObject eventJson) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
            Intrinsics.checkNotNullParameter((Object)eventJson, (String)"eventJson");
            this.log.debug(eventJson.toJSONString(new JSONWriter.Feature[0]));
            String string = eventJson.getString("post_type");
            if (string == null) break block16;
            int n = -1;
            switch (string.hashCode()) {
                case 1095692943: {
                    if (string.equals("request")) {
                        n = 1;
                    }
                    break;
                }
                case 954925063: {
                    if (string.equals("message")) {
                        n = 2;
                    }
                    break;
                }
                case 1198298080: {
                    if (string.equals("meta_event")) {
                        n = 3;
                    }
                    break;
                }
                case -1039690024: {
                    if (string.equals("notice")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.handleMessage(bot, eventJson);
                    break;
                }
                case 4: {
                    this.handleNotice(bot, eventJson);
                    break;
                }
                case 1: {
                    this.handleRequest(bot, eventJson);
                    break;
                }
                case 3: {
                    this.handleMeta(bot, eventJson);
                }
            }
        }
    }

    private void handleMessage(Bot bot, JSONObject eventJson) {
        block22: {
            String string = eventJson.getString("message_type");
            if (string == null) break block22;
            int n = -1;
            switch (string.hashCode()) {
                case 98712563: {
                    if (string.equals("guild")) {
                        n = 1;
                    }
                    break;
                }
                case -314497661: {
                    if (string.equals("private")) {
                        n = 2;
                    }
                    break;
                }
                case 98629247: {
                    if (string.equals("group")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    PrivateMessageEvent event = (PrivateMessageEvent)JSON.parseObject((String)$this$to$iv, PrivateMessageEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl2 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onPrivateMessage(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 3: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupMessageEvent event = (GroupMessageEvent)JSON.parseObject((String)$this$to$iv, GroupMessageEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl3 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupMessage(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 1: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GuildMessageEvent event = (GuildMessageEvent)JSON.parseObject((String)$this$to$iv, GuildMessageEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl4 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGuildMessage(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
            }
        }
    }

    private void handleNotice(Bot bot, JSONObject eventJson) {
        block103: {
            String string = eventJson.getString("notice_type");
            if (string == null) break block103;
            int n = -1;
            switch (string.hashCode()) {
                case 1084899727: {
                    if (string.equals("group_admin")) {
                        n = 1;
                    }
                    break;
                }
                case -504762452: {
                    if (string.equals("channel_created")) {
                        n = 2;
                    }
                    break;
                }
                case -144205887: {
                    if (string.equals("group_upload")) {
                        n = 3;
                    }
                    break;
                }
                case -2133286306: {
                    if (string.equals("group_decrease")) {
                        n = 4;
                    }
                    break;
                }
                case -1449733680: {
                    if (string.equals("essence")) {
                        n = 5;
                    }
                    break;
                }
                case -1823156648: {
                    if (string.equals("offline_file")) {
                        n = 6;
                    }
                    break;
                }
                case -1039689911: {
                    if (string.equals("notify")) {
                        n = 7;
                    }
                    break;
                }
                case -1482667441: {
                    if (string.equals("group_ban")) {
                        n = 8;
                    }
                    break;
                }
                case -1756351616: {
                    if (string.equals("friend_add")) {
                        n = 9;
                    }
                    break;
                }
                case 1642980829: {
                    if (string.equals("channel_destroyed")) {
                        n = 10;
                    }
                    break;
                }
                case 1683396610: {
                    if (string.equals("group_increase")) {
                        n = 11;
                    }
                    break;
                }
                case 571608806: {
                    if (string.equals("client_status")) {
                        n = 12;
                    }
                    break;
                }
                case -1336377682: {
                    if (string.equals("message_reactions_updated")) {
                        n = 13;
                    }
                    break;
                }
                case -240533295: {
                    if (string.equals("group_recall")) {
                        n = 14;
                    }
                    break;
                }
                case -1691706414: {
                    if (string.equals("friend_recall")) {
                        n = 15;
                    }
                    break;
                }
                case 1281979600: {
                    if (string.equals("group_card")) {
                        n = 16;
                    }
                    break;
                }
                case -1767747201: {
                    if (string.equals("channel_updated")) {
                        n = 17;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupUploadNoticeEvent event = (GroupUploadNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupUploadNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl2 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupUploadNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 1: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupAdminChangeNoticeEvent event = (GroupAdminChangeNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupAdminChangeNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl3 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupAdminChangeNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 4: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupMemberDecreaseNoticeEvent event = (GroupMemberDecreaseNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupMemberDecreaseNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl4 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupMemberDecreaseNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 11: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupMemberIncreaseNoticeEvent event = (GroupMemberIncreaseNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupMemberIncreaseNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl5 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupMemberIncreaseNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 8: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupBanNoticeEvent event = (GroupBanNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupBanNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl6 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupBanNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 9: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    FriendAddNoticeEvent event = (FriendAddNoticeEvent)JSON.parseObject((String)$this$to$iv, FriendAddNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl7 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onFriendAddNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 14: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupRecallNoticeEvent event = (GroupRecallNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupRecallNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl8 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupRecallNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 15: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    FriendRecallNoticeEvent event = (FriendRecallNoticeEvent)JSON.parseObject((String)$this$to$iv, FriendRecallNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl9 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onFriendRecallNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 16: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupCardUpdateNoticeEvent event = (GroupCardUpdateNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupCardUpdateNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl10 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupCardUpdateNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 6: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    OfflineFileNoticeEvent event = (OfflineFileNoticeEvent)JSON.parseObject((String)$this$to$iv, OfflineFileNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl11 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onOfflineFileNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 12: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    ClientStatusChangeNoticeEvent event = (ClientStatusChangeNoticeEvent)JSON.parseObject((String)$this$to$iv, ClientStatusChangeNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl12 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onOtherClientStatusChangeNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 5: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    EssenceNoticeEvent event = (EssenceNoticeEvent)JSON.parseObject((String)$this$to$iv, EssenceNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl13 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onEssenceNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 7: {
                    this.handleNotify(bot, eventJson);
                    break;
                }
                case 13: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    MessageReactionsUpdatedNoticeEvent event = (MessageReactionsUpdatedNoticeEvent)JSON.parseObject((String)$this$to$iv, MessageReactionsUpdatedNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl14 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onMessageReactionsUpdatedNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 17: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    ChannelUpdatedNoticeEvent event = (ChannelUpdatedNoticeEvent)JSON.parseObject((String)$this$to$iv, ChannelUpdatedNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl15 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onChannelUpdatedNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 2: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    ChannelCreatedNoticeEvent event = (ChannelCreatedNoticeEvent)JSON.parseObject((String)$this$to$iv, ChannelCreatedNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl16 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onChannelCreatedNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 10: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    ChannelDestroyedNoticeEvent event = (ChannelDestroyedNoticeEvent)JSON.parseObject((String)$this$to$iv, ChannelDestroyedNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl17 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onChannelDestroyedNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
            }
        }
    }

    private void handleNotify(Bot bot, JSONObject eventJson) {
        block25: {
            String string = eventJson.getString("sub_type");
            if (string == null) break block25;
            int n = -1;
            switch (string.hashCode()) {
                case -294065522: {
                    if (string.equals("lucky_king")) {
                        n = 1;
                    }
                    break;
                }
                case 99462250: {
                    if (string.equals("honor")) {
                        n = 2;
                    }
                    break;
                }
                case 110371416: {
                    if (string.equals("title")) {
                        n = 3;
                    }
                    break;
                }
                case 3446681: {
                    if (string.equals("poke")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupHonorChangeNoticeEvent event = (GroupHonorChangeNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupHonorChangeNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl2 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupHonorChangeNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 4: {
                    this.handlePoke(bot, eventJson);
                    break;
                }
                case 1: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupLuckyKingChangeNoticeEvent event = (GroupLuckyKingChangeNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupLuckyKingChangeNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl3 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupLuckyKingChangeNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
                case 3: {
                    String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                    boolean $i$f$to = false;
                    GroupTitleUpdateNoticeEvent event = (GroupTitleUpdateNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupTitleUpdateNoticeEvent.class);
                    Iterable $this$forEach$iv = this.botProperties.getPluginList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        Class pluginClass = (Class)element$iv;
                        boolean bl4 = false;
                        BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                        if (botPlugin != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            bl = botPlugin.onGroupTitleUpdateNotice(bot, event) == 0;
                        } else {
                            bl = false;
                        }
                        if (!bl) continue;
                        return;
                    }
                    break;
                }
            }
        }
    }

    private void handleRequest(Bot bot, JSONObject eventJson) {
        block7: {
            String string;
            block6: {
                string = eventJson.getString("request_type");
                if (!Intrinsics.areEqual((Object)string, (Object)"friend")) break block6;
                String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                boolean $i$f$to = false;
                FriendRequestEvent event = (FriendRequestEvent)JSON.parseObject((String)$this$to$iv, FriendRequestEvent.class);
                Iterable $this$forEach$iv = this.botProperties.getPluginList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean bl;
                    Class pluginClass = (Class)element$iv;
                    boolean bl2 = false;
                    BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                    if (botPlugin != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                        bl = botPlugin.onFriendRequest(bot, event) == 0;
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    return;
                }
                break block7;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"group")) break block7;
            String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
            boolean $i$f$to = false;
            GroupRequestEvent event = (GroupRequestEvent)JSON.parseObject((String)$this$to$iv, GroupRequestEvent.class);
            Iterable $this$forEach$iv = this.botProperties.getPluginList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Class pluginClass = (Class)element$iv;
                boolean bl3 = false;
                BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                if (botPlugin != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                    bl = botPlugin.onGroupRequest(bot, event) == 0;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                return;
            }
        }
    }

    private void handlePoke(Bot bot, JSONObject eventJson) {
        if (eventJson.containsKey("group_id")) {
            String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
            boolean $i$f$to = false;
            GroupPokeNoticeEvent event = (GroupPokeNoticeEvent)JSON.parseObject((String)$this$to$iv, GroupPokeNoticeEvent.class);
            Iterable $this$forEach$iv = this.botProperties.getPluginList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Class pluginClass = (Class)element$iv;
                boolean bl2 = false;
                BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                if (botPlugin != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                    bl = botPlugin.onGroupPokeNotice(bot, event) == 0;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                return;
            }
        } else {
            String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
            boolean $i$f$to = false;
            FriendPokeNoticeEvent event = (FriendPokeNoticeEvent)JSON.parseObject((String)$this$to$iv, FriendPokeNoticeEvent.class);
            Iterable $this$forEach$iv = this.botProperties.getPluginList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Class pluginClass = (Class)element$iv;
                boolean bl3 = false;
                BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                if (botPlugin != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                    bl = botPlugin.onFriendPokeNotice(bot, event) == 0;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                return;
            }
        }
    }

    private void handleMeta(Bot bot, JSONObject eventJson) {
        block7: {
            String string;
            block6: {
                string = eventJson.getString("meta_event_type");
                if (!Intrinsics.areEqual((Object)string, (Object)"heartbeat")) break block6;
                String $this$to$iv = eventJson.toJSONString(new JSONWriter.Feature[0]);
                boolean $i$f$to = false;
                HeartbeatMetaEvent event = (HeartbeatMetaEvent)JSON.parseObject((String)$this$to$iv, HeartbeatMetaEvent.class);
                Iterable $this$forEach$iv = this.botProperties.getPluginList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean bl;
                    Class pluginClass = (Class)element$iv;
                    boolean bl2 = false;
                    BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                    if (botPlugin != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                        bl = botPlugin.onHeartbeatMeta(bot, event) == 0;
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    return;
                }
                break block7;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"lifecycle")) break block7;
            LifecycleMetaEvent event = (LifecycleMetaEvent)eventJson.toJavaObject(LifecycleMetaEvent.class, new JSONReader.Feature[0]);
            Iterable $this$forEach$iv = this.botProperties.getPluginList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Class pluginClass = (Class)element$iv;
                boolean bl3 = false;
                BotPlugin botPlugin = (BotPlugin)this.getPlugin(pluginClass);
                if (botPlugin != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                    bl = botPlugin.onLifecycleMeta(bot, event) == 0;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                return;
            }
        }
    }
}

