/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.dao;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.log4j.Logger;
import top.onceio.core.db.dao.tpl.GroupTpl;
import top.onceio.core.db.dao.tpl.HavingTpl;
import top.onceio.core.db.dao.tpl.OrderTpl;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.dao.tpl.Tpl;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.db.meta.DDEngine;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.util.OUtils;

public class Cnd<E>
extends Tpl {
    private static final Logger LOGGER = Logger.getLogger(Cnd.class);
    private Integer page;
    private Integer pagesize;
    private E pageArg;
    private Boolean isNext;
    private HavingTpl<E> having;
    private GroupTpl<E> group;
    private OrderTpl<E> order;
    private List<Object> args = new ArrayList<Object>();
    private String opt = null;
    private Object[] inVals;
    private String logic = null;
    private List<String> extLogics = new ArrayList<String>();
    private List<Cnd<E>> extCnds = new ArrayList<Cnd<E>>();
    private StringBuffer selfSql = new StringBuffer();
    private Class<E> tplClass;
    private E tpl;
    private boolean usingRm = false;

    public Cnd(Class<E> tplClass) {
        this.tplClass = tplClass;
        CndSetterProxy cglibProxy = new CndSetterProxy();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(tplClass);
        enhancer.setCallback((Callback)cglibProxy);
        this.tpl = enhancer.create();
    }

    public Integer getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(Integer pagesize) {
        this.pagesize = pagesize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPage() {
        return this.page;
    }

    public E getPageArg() {
        return this.pageArg;
    }

    public void setPageArg(E pageArg) {
        this.pageArg = pageArg;
    }

    public Boolean getIsNext() {
        return this.isNext;
    }

    public void setIsNext(Boolean isNext) {
        this.isNext = isNext;
    }

    public E eq() {
        this.opt = "=";
        return this.tpl;
    }

    public E ne() {
        this.opt = "!=";
        return this.tpl;
    }

    public E lt() {
        this.opt = "<";
        return this.tpl;
    }

    public E le() {
        this.opt = "<=";
        return this.tpl;
    }

    public E gt() {
        this.opt = ">";
        return this.tpl;
    }

    public E ge() {
        this.opt = ">=";
        return this.tpl;
    }

    public E is_null() {
        this.opt = "IS NULL";
        return this.tpl;
    }

    public E not_null(E e) {
        this.opt = "IS NOT NULL";
        return this.tpl;
    }

    public E in(Object[] vals) {
        this.opt = "IN";
        this.inVals = vals;
        return this.tpl;
    }

    public E like() {
        this.opt = "LIKE";
        return this.tpl;
    }

    public E pattern() {
        this.opt = "~*";
        return this.tpl;
    }

    public Cnd<E> and() {
        if (this.opt != null) {
            this.logic = "AND";
        }
        return this;
    }

    public Cnd<E> or() {
        if (this.opt != null) {
            this.logic = "OR";
        }
        return this;
    }

    public Cnd<E> not() {
        if (this.opt != null) {
            this.logic = "NOT";
        }
        return this;
    }

    public Cnd<E> and(Cnd<E> extCnd) {
        this.extLogics.add("AND");
        this.extCnds.add(extCnd);
        return this;
    }

    public Cnd<E> or(Cnd<E> extCnd) {
        this.extLogics.add("OR");
        this.extCnds.add(extCnd);
        return this;
    }

    public Cnd<E> not(Cnd<E> extCnd) {
        this.extLogics.add("NOT");
        this.extCnds.add(extCnd);
        return this;
    }

    public String whereSql(List<Object> sqlArgs) {
        StringBuffer self = new StringBuffer();
        if (this.selfSql.length() > 0) {
            self.append("(" + this.selfSql);
            if (!this.usingRm) {
                self.append(" AND rm = false");
            }
            self.append(")");
        } else {
            self.append("(rm = false)");
        }
        sqlArgs.addAll(this.args);
        for (int i = 0; i < this.extLogics.size(); ++i) {
            String sl = this.extLogics.get(i);
            Cnd<E> c = this.extCnds.get(i);
            String other = c.whereSql(sqlArgs);
            if (!other.equals("")) {
                switch (sl) {
                    case "AND": {
                        if (self.length() > 0) {
                            self.append(" AND");
                        }
                        self.append(other);
                        break;
                    }
                    case "OR": {
                        if (self.length() > 0) {
                            self.append(" OR");
                        }
                        self.append(other);
                        break;
                    }
                    case "NOT": {
                        if (self.length() > 0) {
                            self.append(" AND NOT");
                        } else {
                            self.append(" NOT");
                        }
                        self.append(other);
                        break;
                    }
                }
                continue;
            }
            LOGGER.warn((Object)"\u67e5\u8be2\u6761\u4ef6\u662f\u7a7a\u7684");
        }
        return self.toString();
    }

    public String afterWhere(TableMeta tm, List<Object> sqlArgs) {
        String order;
        String having;
        String group;
        String whereCnd;
        StringBuffer afterWhere = new StringBuffer();
        Map<String, String> tokens = null;
        if (tm.getEngine() != null) {
            DDEngine dde = tm.getEngine();
            tokens = dde.getColumnToOrigin();
        }
        if (!(whereCnd = this.whereSql(sqlArgs)).equals("")) {
            if (tokens == null) {
                afterWhere.append(String.format(" WHERE (%s)", whereCnd));
            } else {
                afterWhere.append(String.format(" WHERE (%s)", OUtils.replaceWord(whereCnd, tokens)));
            }
        }
        if ((group = this.group()) != null && !group.isEmpty()) {
            if (tokens == null) {
                afterWhere.append(String.format(" GROUP BY %s", group));
            } else {
                afterWhere.append(String.format(" GROUP BY %s", OUtils.replaceWord(group, tokens)));
            }
        }
        if ((having = this.getHaving(sqlArgs)) != null && !having.isEmpty()) {
            if (tokens == null) {
                afterWhere.append(String.format(" HAVING %s", having));
            } else {
                afterWhere.append(String.format(" HAVING %s", OUtils.replaceWord(having, tokens)));
            }
        }
        if (!(order = this.getOrder()).isEmpty()) {
            if (tokens == null) {
                afterWhere.append(String.format(" ORDER BY %s", order));
            } else {
                afterWhere.append(String.format(" ORDER BY %s", OUtils.replaceWord(order, tokens)));
            }
        }
        return afterWhere.toString();
    }

    public StringBuffer selectSql(TableMeta tm, SelectTpl<E> tpl) {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("SELECT ");
        if (tm.getEngine() == null) {
            if (tpl != null && tpl.sql() != null && !tpl.sql().isEmpty()) {
                sqlSelect.append(tpl.sql());
            } else {
                for (ColumnMeta cm : tm.getColumnMetas()) {
                    sqlSelect.append(cm.getName() + ",");
                }
                sqlSelect.delete(sqlSelect.length() - 1, sqlSelect.length());
            }
            sqlSelect.append(String.format(" FROM %s", tm.getTable()));
        } else {
            DDEngine dde = tm.getEngine();
            HashSet<String> params = new HashSet<String>();
            Map<String, String> colToOrigin = dde.getColumnToOrigin();
            if (tpl != null) {
                params.addAll(tpl.getArgNames());
                sqlSelect.append(tpl.sql(colToOrigin));
            } else {
                for (ColumnMeta cm : tm.getColumnMetas()) {
                    params.add(cm.getName());
                    sqlSelect.append(String.format("%s %s,", colToOrigin.get(cm.getName()), cm.getName()));
                }
                sqlSelect.delete(sqlSelect.length() - 1, sqlSelect.length());
            }
            String mainPath = tm.getEntity().getSuperclass().getSimpleName().toLowerCase();
            String joinTables = dde.genericJoinSqlByParams(mainPath, params, null);
            sqlSelect.append(String.format(" FROM %s", joinTables));
            System.err.println(sqlSelect);
        }
        return sqlSelect;
    }

    public StringBuffer wholeSql(TableMeta tm, SelectTpl<E> tpl, List<Object> sqlArgs) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.selectSql(tm, tpl));
        sql.append(this.afterWhere(tm, sqlArgs));
        return sql;
    }

    public String pageSql(TableMeta tm, SelectTpl<E> tpl, List<Object> sqlArgs) {
        StringBuffer s = this.wholeSql(tm, tpl, sqlArgs);
        s.append(" LIMIT ? OFFSET ?");
        sqlArgs.addAll(Arrays.asList(this.getPagesize(), (this.getPage() - 1) * this.getPagesize()));
        return s.toString();
    }

    public String countSql(TableMeta tm, SelectTpl<E> tpl, List<Object> sqlArgs) {
        String group = this.group();
        if (tm.getEngine() == null) {
            if (group != null && !group.isEmpty()) {
                return String.format("SELECT COUNT(1) FROM (SELECT 1 FROM %s %s) t", tm.getTable(), this.afterWhere(tm, sqlArgs));
            }
            return String.format("SELECT COUNT(1) FROM %s %s", tm.getTable(), this.afterWhere(tm, sqlArgs));
        }
        StringBuffer select = this.selectSql(tm, tpl);
        int fromIndex = select.indexOf("FROM");
        return String.format("SELECT COUNT(1) FROM (SELECT 1 %s %s) t", select.substring(fromIndex), this.afterWhere(tm, sqlArgs));
    }

    public HavingTpl<E> having() {
        if (this.having == null) {
            this.having = new HavingTpl<E>(this.tplClass);
        }
        return this.having;
    }

    public String getHaving(List<Object> sqlArgs) {
        if (this.having != null) {
            return this.having.sql(sqlArgs);
        }
        return null;
    }

    public OrderTpl<E> orderBy() {
        if (this.order == null) {
            this.order = new OrderTpl<E>(this.tplClass);
        }
        return this.order;
    }

    public String getOrder() {
        if (this.order != null) {
            return this.order.getOrder();
        }
        return "";
    }

    public GroupTpl<E> groupBy() {
        if (this.group == null) {
            this.group = new GroupTpl<E>(this.tplClass);
        }
        return this.group;
    }

    public String group() {
        if (this.group != null) {
            return this.group.getGroup();
        }
        return null;
    }

    class CndSetterProxy
    implements MethodInterceptor {
        CndSetterProxy() {
        }

        public Object intercept(Object o, Method method, Object[] argsx, MethodProxy methodProxy) throws Throwable {
            if (method.getName().startsWith("set") && argsx.length == 1 && method.getName().length() > 3) {
                String fieldName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                String strLogic = "";
                if (fieldName.equals("rm")) {
                    if (!Cnd.this.usingRm) {
                        Cnd.this.usingRm = true;
                    } else {
                        return o;
                    }
                }
                if (Cnd.this.logic != null) {
                    strLogic = Cnd.this.logic.toString() + " ";
                }
                if (Cnd.this.opt.equals("IN") && Cnd.this.inVals != null && Cnd.this.inVals.length > 1) {
                    String stub = OUtils.genStub("?", ",", Cnd.this.inVals.length);
                    Cnd.this.selfSql.append(String.format("%s%s %s (%s)", strLogic, fieldName, Cnd.this.opt, stub));
                    for (Object v : Cnd.this.inVals) {
                        Cnd.this.args.add(v);
                    }
                } else if (Cnd.this.opt.equals("IS NULL")) {
                    Cnd.this.selfSql.append(String.format("%s%s IS NULL", strLogic, fieldName));
                } else if (Cnd.this.opt.equals("IS NOT NULL")) {
                    Cnd.this.selfSql.append(String.format("%s%s IS NOT NULL", strLogic, fieldName));
                } else {
                    Cnd.this.selfSql.append(String.format("%s%s %s ?", strLogic, fieldName, Cnd.this.opt));
                    Cnd.this.args.add(argsx[0]);
                }
            }
            return o;
        }
    }
}

